% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{height}
\alias{height}
\alias{height<-}
\alias{set_height}
\alias{height.huxtable}
\alias{height<-.huxtable}
\title{Get or Set Table Height}
\usage{
height(ht)
height(ht) <- value
set_height(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one vector. If numeric, it is treated as a proportion of the containing block height for HTML, or of text height (\\textheight) for LaTeX. If character, it must be a valid CSS or LaTeX width. Set to \code{NA} for the default, which is to leave height unset.}
}
\value{
For \code{height}, the \code{height} attribute.
For \code{set_height}, the \code{ht} object.
}
\description{
Functions to get or set the table-level table height property of a huxtable.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
height(ht) <-  0.4
height(ht)

}
\seealso{
Other table measurements: \code{\link{width}}
}
