% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{number_format}
\alias{number_format}
\alias{number_format<-}
\alias{set_number_format}
\alias{map_number_format}
\title{Set how numbers are formatted in cells}
\usage{
number_format(ht)
number_format(ht) <- value
set_number_format(ht, row, col, value )
map_number_format(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{value}{A character or integer vector,

Note that setting to \code{NA} does not reset to the default.}
}
\value{
\code{number_format()} returns the \code{number_format} property.
\code{set_number_format()} returns the modified huxtable.
}
\description{
If \code{number_format} is:
\itemize{
\item numeric, numbers will be rounded to that many decimal places;
\item character, it will be used as an argument to \code{\link[=sprintf]{sprintf()}};
\item a function, the function will be applied to the numbers;
\item \code{NA}, then numbers will not be formatted (except by conversion with
\code{as.character}).
}
}
\details{
Number formatting is applied to any parts of cells that look like numbers.
The exception is exponents in
scientific notation; huxtable attempts to detect and ignore these.

The default value is "\\%.3g", which rounds numbers if they have more than 3
significant digits, and which may use scientific notation for large numbers.

Note that if your cells are of type numeric, a number format of \code{NA} doesn't
guarantee you get back what you typed in, since R's default conversion may
apply scientific notation and rounding.

To set number_format to a function, enclose the function in \code{list}. The function should
take one argument and return a string. \code{\link[=fmt_pretty]{fmt_pretty()}} and \code{\link[=fmt_percent]{fmt_percent()}}
are useful shortcuts for common formatting functions.
}
\examples{
ht <- huxtable(
        number_format = c(
          "Default",
          "NA",
          "2",
          "\"\%5.2f\"",
          "Pretty",
          "Sign"
        ),
        a = rep(1000, 6),
        b = rep(1000.005, 6),
        c = rep(0.0001, 6),
        d = rep(-1, 6),
        e = rep("3.2 (s.e. 1.4)", 6)
      )

number_format(ht)[3, -1] <- NA
number_format(ht)[4, -1] <- 2
number_format(ht)[5, -1] <- "\%5.2f"

number_format(ht)[6, -1] <- fmt_pretty()

number_format(ht)[7, -1] <- list(
        function(x) if (x > 0) "+" else "-"
      )

right_border(ht) <- 1
bottom_border(ht)[1, ] <- 1

ht

ht_bands <- huxtable("10000 Maniacs", autoformat = FALSE)
# probably not what you want:
ht_bands
# fixed:
set_number_format(ht_bands, NA)

}
\seealso{
Other formatting functions: 
\code{\link{background_color}()},
\code{\link{bold}()},
\code{\link{font_size}()},
\code{\link{font}()},
\code{\link{na_string}()},
\code{\link{text_color}()}
}
\concept{formatting functions}
