% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwe.R
\name{hwefreq}
\alias{hwefreq}
\title{Generate HWE genotype frequencies}
\usage{
hwefreq(
  r,
  alpha,
  ploidy,
  niter = 100,
  tol = sqrt(.Machine$double.eps),
  more = FALSE
)
}
\arguments{
\item{r}{The allele frequency of the reference allele.}

\item{alpha}{A numeric vector containing the double reduction parameter(s).
This should be a
vector of length \code{floor(ploidy/4)} where \code{alpha[i]}
is the probability of exactly \code{i} pairs of IBDR alleles
being in the gamete. Note that \code{sum(alpha)} should be less than
1, as \code{1 - sum(alpha)} is the probability of no double reduction.}

\item{ploidy}{The ploidy of the species. This should be an even positive
integer.}

\item{niter}{The maximum number of iterations to simulate.}

\item{tol}{The stopping criterion on the Chi-square divergence between
old and new genotype frequencies.}

\item{more}{A logical. Should we return more output (\code{TRUE}) or
less (\code{FALSE}). See the Value section for details.}
}
\value{
If \code{more = FALSE}, then returns just the genotype frequencies
after \code{niter} generations of random mating. If \code{more = TRUE},
then returns a list with these genotype frequencies, as well as
the parental gamete frequencies.
}
\description{
Generate genotype frequencies under Hardy-Weinberg equilibrium
given the allele frequency of the reference allele (\code{r}),
the double reduction parameter (\code{alpha}), and the ploidy
of the species (\code{ploidy}).
}
\details{
If \code{alpha} is not all 0, then this function repeatedly
applies \code{\link{freqnext}()} to simulate genotype frequencies
under HWE. Otherwise, it uses \code{\link[stats]{dbinom}()}.
}
\examples{
freq1 <- hwefreq(r = 0.5, alpha = 0, ploidy = 4)
freq2 <- hwefreq(r = 0.5, alpha = 1/6, ploidy = 4)

plot(x = 0:4,
     y = freq1,
     type = "h",
     ylim = c(0, 0.4),
     xlab = "dosage",
     ylab = "Pr(dosage)")
plot(x = 0:4,
     y = freq2,
     type = "h",
     ylim = c(0, 0.4),
     xlab = "dosage",
     ylab = "Pr(dosage)")

}
\author{
David Gerard
}
