% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_contact_chain.R
\name{findContactChain}
\alias{findContactChain}
\title{Finding elements in contact chains of a dynamic network.}
\usage{
findContactChain(Data, from, to, Time, selected.nodes, type = "size",
  numberOfcores = NULL)
}
\arguments{
\item{Data}{\code{\link{data.frame}} with network information: node ID, origin
node, destination node, and the time in which the link was established.}

\item{from}{\code{\link{character}}, variable name (column name) for origin node.}

\item{to}{\code{\link{character}}, variable name (column name) for destination node.}

\item{Time}{\code{\link{character}}, variable name (column name) for the time
in which the link was established between two nodes.}

\item{selected.nodes}{\code{\link{vector}}, the function will find the contact
chain of the nodes present in the selected.nodes vector.}

\item{type}{\code{\link{character}}, of returned reuslt. Type = 'size' (default),
will return the size of 'outgoing' and 'ingoing' contact chains.
Type = 'chain' will return also the nodes in each chain (might be slow
for hugh data sets).}

\item{numberOfcores}{\code{\link{integer}}, number of cores used to calculate
the contact chain (default is NULL, that will lead the algotrithm to
use the max number of cores).}
}
\value{
a \code{\link{data.frame}} with ingoing and outgoing contact chains size.
        or \code{\link{list}} with the data frame and elements of ingoing and
        outgoing chains.
}
\description{
Parallel function to find outgoing and ingoing contact chain
             elements.
}
\details{
This is a function that find elements of a contact chain from a dynamic
         network.
}
\examples{
# Loading data
data(networkSample) # help("networkSample"), for more info.
 
# contact chain function
selected.nodes <- c(37501, 36811, 36812)
contact.chain <- findContactChain(Data = networkSample, from = 'originID',
                                  to = 'destinationID', Time = 'Day', selected.nodes,
                                  type = 'chain', numberOfcores = 2)
}
\references{
[1] K Buttner, J Krieter, and I Traulsen. Characterization of Contact Structures
    for the Spread of Infectious Diseases in a Pork Supply Chain in Northern
    Germany by Dynamic Network Analysis of Yearly and Monthly Networks. In:
    Transboundary and emerging diseases 2000 (May 2013), pp. 1-12.
    
[2] C Dube, C Ribble, D Kelton, et al. Comparing network analysis measures to
    determine potential epidemic size of highly contagious exotic diseases in
    fragmented monthly networks of dairy cattle movements in Ontario, Canada.
    In: Transboundary and emerging diseases 55.9-10 (Dec. 2008), pp. 382-392.
    
[3] C Dube, C Ribble, D Kelton, et al. A review of network analysis terminology
    and its application to foot-and-mouth disease modelling and policy development.
    In: Transboundary and emerging diseases 56.3 (Apr. 2009), pp. 73-85.
    
[4] Jenny Frossling, Anna Ohlson, Camilla Bjorkman, et al. Application of
    network analysis parameters in risk-based surveillance - Examples based
    on cattle trade data and bovine infections in Sweden. In:  Preventive
    veterinary medicine 105.3 (July 2012), pp. 202-208.
    doi: 10.1016/j.prevetmed.2011.12.011.
    
[5] Maria Noremark, Nina Ha kansson, Susanna Sternberg Lewerin, et al.
    Network analysis of cattle and pig movements in Sweden: measures relevant
    for disease control and risk based surveillance. In: Preventive veterinary
    medicine 99.2-4 (2011), pp. 78-90. doi: 10.1016/j.prevetmed.2010.12.009.
}
