% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manningt.R
\name{manningt}
\alias{manningt}
\title{Solves the Manning Equation for water flow in an open channel}
\usage{
manningt(
  Q = NULL,
  n = NULL,
  m = NULL,
  Sf = NULL,
  y = NULL,
  b = NULL,
  units = c("SI", "Eng")
)
}
\arguments{
\item{Q}{numeric vector that contains the flow rate [m^3/s or or ft^3/s]}

\item{n}{numeric vector that contains the Manning roughness coefficient}

\item{m}{numeric vector that contains the side slope of the channel (m:1 H:V) [unitless]}

\item{Sf}{numeric vector that contains the slope of the channel [unitless]}

\item{y}{numeric vector that contains the water depth [m or ft]}

\item{b}{numeric vector that contains the channel bottom width [m or ft]}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package.}
}
\value{
Returns a list including the missing parameter:
\itemize{
  \item Q - flow rate
  \item V - flow velocity
  \item A - cross-sectional area of flow
  \item P - wetted perimeter
  \item R - hydraulic radius
  \item y - flow depth (normal depth)
  \item b - channel bottom width
  \item m - channel side slope
  \item Sf - slope
  \item B - top width of water surface
  \item n - Manning's roughness
  \item yc - critical depth
  \item Fr - Froude number
  \item Re - Reynolds number
}
}
\description{
This function solves the Manning equation for water
flow in an open channel with a trapezoidal shape. This is a modification of the
code prepared by Irucka Embry in his iemisc package. Specifically
the iemisc::manningtrap, iemisc::manningrect, and iemisc::manningtri were combined
and adapted here for more limited cases commonly used in classroom exercises.Some
auxiliary variables in the iemisc code are not included here (shear stress, and
specific energy), as these will be done separately. A cross-section figure is also
available.
}
\examples{

#Solving for flow rate, Q, trapezoidal channel: SI Units
manningt(n = 0.013, m = 2, Sf = 0.0005, y = 1.83, b = 3, units = "SI")
#returns Q=22.2 m3/s

#Solving for roughness, n, rectangular channel: Eng units
manningt(Q = 14.56, m = 0, Sf = 0.0004, y = 2.0, b = 4, units = "Eng")
#returns Manning n of 0.016

#Solving for depth, y, triangular channel: SI units
manningt(Q = 1.0, n = 0.011, m = 1, Sf = 0.0065, b = 0, units = "SI")
#returns 0.6 m normal flow depth

}
\author{
Ed Maurer, Irucka Embry
}
