%% File ReadPlot_Results.R
%% Part of the hydroPSO R package, http://www.rforge.net/hydroPSO/ ; 
%%                                 http://cran.r-project.org/web/packages/hydroPSO
%% Copyright 2010-2012 Mauricio Zambrano-Bigiarini & Rodrigo Rojas
%% Distributed under GPL 2 or later

\name{ReadPlot_results}
\Rdversion{1.1}
\alias{read_results}
\alias{plot_results}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Reading/Plotting all the output files generated by \sQuote{hydroPSO}
}
\description{
The function \code{read_results} reads the following output files of hydroPSO: \cr

1) \sQuote{BestParameterSet.txt}: best parameter set and its corresponding goodness-of-fit found during the optimisation \cr
2) \sQuote{Particles.txt}: parameter values and their corresponding goodness-of-fit for all particles and iterations \cr
3) \sQuote{Velocities.txt}: velocity values and their corresponding goodness-of-fit for all particles and iterations \cr
4) \sQuote{Model_out.txt}: values of the objective function/model output for each particle and iteration \cr
5) \sQuote{ConvergenceMeasures.txt}: convergence measures summarizing performance of hydroPSO \cr
6) \sQuote{Particles_GofPerIter.txt}: goodness-of-fit only for all the particles during all the iterations \cr

The function \code{plot_results} takes the outputs of the \code{read_results} function and then produces the following plots: \cr

 1) Dotty plots of parameter values \cr
 2) Histograms of parameter values \cr
 3) Boxplots of parameter values \cr
 4) Correlation matrix among parameter values (optional) \cr
 5) Empirical CDFs of parameter values\cr
 6) Parameter values vs Number of Model Evaluations \cr
 7) (pseudo) 3D dotty plots of (selected) parameter values \cr
 8) GoF for each particle against Number of Model Evaluations \cr
 9) Velocity values vs Number of Model Evaluations \cr
10a) Scatterplot between Best Simulated values and Observations (OPTIONAL, only if \code{MinMax} is provided)  \cr
10b) Empirical CDFs for model's output (only produced if \code{obs} is NOT a zoo object)  \cr
10b) ggof (See \code{\link[hydroGOF]{ggof}}) between Best Simulated values and Observations (OPTIONAL, only if \code{obs} is a zoo object) \cr
10d) Empirical CDFs for selected quantiles of model's output (OPTIONAL, only if \code{obs} is a zoo object) \cr
11) Convergence Measures (Gbest and normSwarmRadius) vs Iteration Number
}
\usage{
read_results(drty.out="PSO.out", MinMax=NULL, beh.thr=NA, 
             modelout.cols=NULL, verbose=TRUE)
           
plot_results(drty.out="PSO.out", param.names, gof.name="GoF", MinMax=NULL, 
     beh.thr=NA, beh.col="red", beh.lty=1, beh.lwd=2, nrows="auto", 
     col="black", ylab=gof.name, main=NULL, pch=19, cex=0.5, cex.main=1.7, 
     cex.axis=1.3, cex.lab=1.5, breaks="Scott", freq=TRUE, do.pairs=FALSE,
     weights=NULL, byrow=FALSE, leg.cex=1.2,
     %%...
     %% Parameters for the 3D dotty plots
     dp3D.names="auto", GOFcuts="auto", 
     colorRamp= colorRampPalette(c("darkred", "red", "orange", "yellow", 
     "green", "darkgreen", "cyan")), alpha=0.65, points.cex=0.7, 
     %% Parameters for GoF per Particle
     ptype="one",
     %% Parameters for 'plot_out'
     modelout.cols=NULL,
     ftype="o", FUN=mean, 
     quantiles.desired= c(0.05,0.5,0.95), 
     quantiles.labels= c("Q5","Q50","Q95"),
     %% Parameters for plot_convergence'
     legend.pos="topright", 
     %% PNG options
     do.png=FALSE, png.width=1500, png.height=900, png.res=90, 
     dotty.png.fname="Params_DottyPlots.png", 
     hist.png.fname ="Params_Histograms.png",
     bxp.png.fname="Params_Boxplots.png",
     ecdf.png.fname ="Params_ECDFs.png", 
     pruns.png.fname="Params_ValuesPerRun.png",
     dp3d.png.fname ="Params_dp3d.png", 
     pairs.png.fname="Params_Pairs.png",
     part.png.fname ="Particles_GofPerIter.png",
     vruns.png.fname="Velocities_ValuePerRun.png", 
     modelout.best.png.fname="ModelOut_BestSim_vs_Obs.png",
     modelout.quant.png.fname="ModelOut_Quantiles.png",
     conv.png.fname ="ConvergenceMeasures.png", verbose=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{drty.out}{
character, path to the directory storing the output files generated by \kbd{hydroPSO}
}
  \item{param.names}{
character, names for the parameters in \code{params} that have to be plotted (\code{param.names} can be a subset of \code{params}). \cr
Names for each parameter are taken from the first row of the \sQuote{Particles.txt} file
}
  \item{verbose}{
logical, if TRUE, progress messages are printed
}
  \item{gof.name}{
character, name of the goodness-of-fit variable in all plots
}
  \item{MinMax}{
OPTIONAL. character, indicates whether the optimum value in \code{x} corresponds to the minimum or maximum of the objective function. It is only used to identify the optimum on the plots \cr
Valid values are in: \code{c('min', 'max')}
}
  \item{beh.thr}{
OPTIONAL. numeric, threshold to filter out parameter sets and model outputs with a non-acceptable performance (non behavioural parameter sets)
}
  \item{modelout.cols}{
numeric, column number in \code{file} that store the outputs that have to be read/plotted, without counting the first three that correspond to iteration, particle and GoF.  If \code{modelout.cols=NULL}, all the columns in \code{will be read}, but the first trhee that contains the iteration number, the particle number and the corresponding goodness-of-fit. See \code{\link{read_out}} 
}
  \item{beh.col}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
character, colour for drawing a horizontal line for separating behavioural from non behavioural parameter sets
}
  \item{beh.lty}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric, line type for drawing a horizontal line for separating behavioural from non behavioural parameter sets
}
  \item{beh.lwd}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric, width for drawing a horizontal line for separating behavioural from non behavioural parameter sets
}
  \item{nrows}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric, number of rows to be used in the plotting window \cr
If \code{nrows}is set to \kbd{auto}, the number of rows is automatically computed depending on the number of columns of \code{x}
}
  \item{col}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
character, colour to be used for drawing the points of the dotty plots 
}
  \item{ylab}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
character, label for the 'y' axis
}
  \item{main}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
character, title for the plot
}
  \item{pch}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric, type of symbol to be used for drawing the points of the dotty plots. (e.g., 1: white circle)
}
  \item{cex}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric, values controlling the size of text and points with respect to the default
}
  \item{cex.main}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric, magnification for main titles relative to the current setting of \code{cex}
}
  \item{cex.axis}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric, magnification for axis annotation relative to the current setting of \code{cex}
}
  \item{cex.lab}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric, magnification for x and y labels relative to the current setting of \code{cex}
}
%%  \item{\dots}{
%%OPTIONAL. Only used when \code{plot=TRUE} \cr
%%further arguments passed to the plot command or from other methods
%%}
  \item{breaks}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
breaks for plotting the histograms of the parameter sets. See \code{\link[graphics]{hist}}
}
  \item{freq}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
logical, if TRUE, the histogram graphic is a representation of frequencies, the counts component of the result; if FALSE, probability densities, component density, are plotted (so that the histogram has a total area of one). Defaults to TRUE if and only if breaks are equidistant (and probability is not specified). See \code{\link[graphics]{hist}}
}
  \item{do.pairs}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
logical, indicates whether a correlation matrix among parameters has to be plotted. If the number of parameter sets tried during the optimisation is large, it may require some time. 
}
  \item{weights}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
numeric vector, values of the weights to be used for computing the empirical CDFs. See \code{\link{params2ecdf}}
}
  \item{byrow}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
logical, indicates whether the computations have to be made for each column or for each row of \code{x}. See \code{\link{params2ecdf}}
}
  \item{leg.cex}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
character expansion factor *relative* to current 'par("cex")'. Used for text, and provides the default for 'pt.cex' and 'title.cex'. Default value = 1.2
}
  \item{dp3D.names}{
character, name for all the parameters (usually only the most sensitive ones) that will be used for plotting pseudo-3D plots \cr
If \code{dp3D.names='auto'} half the number of parameters in \code{file} are chosen randomly for plotting. See \code{\link{plot_NparOF}}
}
  \item{GOFcuts}{
numeric, specifies at which values of the objective function \code{gof.name} the colours of the plot have to change. See \code{\link{plot_NparOF}}
}
  \item{colorRamp}{
R function defining the colour ramp to be used for colouring the pseudo-3D dotty plots of Parameter Values, OR character representing those colours. See \code{\link{plot_NparOF}}
}
  \item{alpha}{
numeric between 0 and 1 representing the transparency level to apply to the colors of the pseudo-3D dotty plots. See \code{\link{plot_NparOF}}
}
  \item{points.cex}{
size of the points to be plotted
}
  \item{ptype}{
character, represents the type of plot. Valid values are: in c("one", "many"), for plotting all the particles in the same figure or in one windows per particle, respectively \cr
See \code{\link{plot_GofPerParticle}} 
}
  \item{ftype}{
OPTIONAL. Only used when \code{plot=TRUE} and the observed values provided by the user were zoo objects. See \code{\link{plot_out}} and \code{\link[hydroGOF]{ggof}}.
}
  \item{FUN}{
OPTIONAL. Only used when \code{plot=TRUE} and the observed values provided by the user were zoo objects. See \code{\link{plot_out}} and \code{\link[hydroGOF]{ggof}}
}
  \item{quantiles.desired}{
numeric vector, quantiles to be computed. Default values are \kbd{c(.025, .5, .975)} ( => 2.5\%, 50\%, 97.5\% ). See \code{\link{plot_out}}
}
  \item{quantiles.labels}{
OPTIONAL. Only used when \code{plot=TRUE} \cr
character vector, names to \code{quantiles.desired}. Default value is \kbd{c("Q5", "Q50", "Q95")}. See \code{\link{plot_out}} 
}
  \item{legend.pos}{
See \code{\link{plot_convergence}} 
}
  \item{do.png}{
logical, indicates if all the figures have to be saved into PNG files instead of the screen device
}
  \item{png.width}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
numeric, width of the PNG device. See \code{\link[grDevices]{png}}
}
  \item{png.height}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
numeric, height of the PNG device. See \code{\link[grDevices]{png}}
}
  \item{png.res}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
numeric, nominal resolution in ppi which will be recorded in the PNG file, if a positive integer of the device. See \code{\link[grDevices]{png}}
}
  \item{dotty.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the dotty plots of the parameter values. 
}
  \item{hist.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the histograms of the parameter values. 
}
  \item{bxp.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the boxplots of the parameter values
}
  \item{ecdf.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the empirical CDFs of the parameter values.
}
  \item{pruns.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the parameter values vs the number of model evaluations
}
  \item{dp3d.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the pseudo-3D plots of all the parameters defined in \code{dp3D.names}
}
  \item{pairs.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the correlation matrix among the parameters and goodness-of-fits measures in \code{params} and \code{gofs}. See \code{\link{plot_particles}} and \code{\link[hydroTSM]{hydropairs}}
}
  \item{part.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the goodness-of-fit for all the particles along the iterations
}
  \item{vruns.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the velocity values vs the number of model evaluations
}
  \item{modelout.best.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the observed values against its best simulated counterpart. See \code{\link{plot_out}}
}
  \item{modelout.quant.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with some quantiles of simulated values against its observed counterparts. See \code{\link{plot_out}}
}
  \item{conv.png.fname}{
OPTIONAL. Only used when \code{do.png=TRUE} \cr
character, filename used to store the PNG file with the convergence measures. See \code{\link{plot_convergence}}
}
}
%%\details{
%%  ~~ If necessary, more details than the description above ~~
%%}
\value{
The function \code{read_results} returns a list with the following elements: 
\item{best.param}{numeric with the best parameter set}
\item{best.gof}{numeric with the best fitness value of the objective function}
\item{params}{data.frame with all the parameter sets tested during the optimisation}
\item{gofs}{numeric with all the fitness values computed during the optimisation (each element in \code{gofs} corresponds to one row of \code{params})}
\item{model.values}{numeric or matrix/data.frame with the values of the objective function / model for each particle and iteration. See \code{\link{read_out}} }
\item{model.best}{numeric with the best model / objective function value. In order to be computed, the user has to provide a valid value for \code{MinMax}. See \code{\link{read_out}} }
\item{model.obs}{numeric with the observed values used during the optimisation. See \code{obs}}
\item{convergence.measures}{matrix/data.frame with the convergence measures. See \code{\link{read_convergence}} function}
\item{part.GofPerIter}{matrix/data.frame with the goodness-of-fit values for all the particles during all the iterations. It has as many columns as parameters to be optimised and as many rows as the number of iterations effectively carried out}
}
%%\references{
%%
%%}
\author{
Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{read_best}}, \code{\link{read_particles}}, \code{\link{read_velocities}}, \code{\link{read_out}}, \code{\link{read_convergence}}, \code{\link{read_GofPerParticle}}, \code{\link{plot_ParamsPerIter}}
}
\examples{
# Setting the user home directory as working directory
setwd("~")

# Number of dimensions to be optimised
nparam <- 5

\dontrun{

# Setting the seed
set.seed(100)

# Runing PSO with the 'ackley' test function, writting the results to text files
hydroPSO(
        fn= "ackley", method="pso", lower=rep(-32, nparam), upper=rep(32, nparam),
        control=list(MinMax="min", npart=2*nparam, maxit=2000, topology="gbest",
                     write2disk=TRUE, REPORT=100,
                     use.RG=TRUE, RG.thr=1e-2, RG.r=1e-5)
        )
  
# Reading all the results and storing them in a variable
res <- read_results()

# Plotting all the results with a goodness-of-fit lower than 5
plot_results(MinMax="min", beh.thr=5)
}

\dontrun{
##########################################################################
####################  SPSO-2007 example START ############################
##########################################################################
# Number of dimensions to be optimised
nparam <- 10

# boundaries for the test function
x <- c(-100, 100)      # "sphere" 
#x <- c(-5.12, 5.12)   # "rastrigin" 
#x <- c(-32, 32)       # "ackley" 

fn <- "sphere"
#fn <- "rastrigin"
#fn <- "ackley"

#######################################
#####   SPSO-2007 parameters   ########
npart  <- floor(10+2*sqrt(nparam))
c1     <- 0.5+log(2)
c2     <- 0.5+log(2)
abstol <- 1e-20 
reltol <- 1e-20
maxit  <- 1000

use.IW        <- TRUE
IW.w          <- 1/(2*log(2))
REPORT        <- 100
lambda        <- 1
boundary.wall <- "absorbing"
#######################################

# Setting the user home directory as working directory
setwd("~")

# Runing PSO  and writting the results to text files
set.seed(100)

hydroPSO(
        fn= fn, method="pso", lower=rep(x[1], nparam), upper=rep(x[2], nparam),
        control=list(MinMax="min", npart=npart, 
                     c1=c1, c2=c2, 
                     use.IW=use.IW, IW.w=IW.w, 
                     maxit=maxit, topology="random", lambda=lambda, K=3,
                     Xini.type="random", Vini.type="random",
                     best.update="async",
                     boundary.wall=boundary.wall, 
                     write2disk=TRUE, plot=FALSE, REPORT=REPORT,
                     abstol=abstol, reltol=reltol 
                     )
        )

# Plotting all the results 
plot_results(MinMax="min")

##########################################################################
####################  SPSO-2007 example END   ############################
##########################################################################
}

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{graph}
\keyword{files}% __ONLY ONE__ keyword per line
