% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_streamorder-level.R
\name{add_streamorder}
\alias{add_streamorder}
\alias{add_streamorder.data.frame}
\alias{add_streamorder.hy}
\title{add Streamorder}
\usage{
add_streamorder(x, status = TRUE)

\method{add_streamorder}{data.frame}(x, status = TRUE)

\method{add_streamorder}{hy}(x, status = TRUE)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{status}{boolean if status updates should be printed.}
}
\value{
data.frame containing added \code{stream_order} and \code{stream_calculator} attribute.
}
\description{
Adds a strahler stream order.

Algorithm: If more than one upstream flowpath has an order equal to the
maximum upstream order then the downstream flowpath is assigned the maximum
upstream order plus one. Otherwise it is assigned the maximum upstream order.

To match the NHDPlus algorithm, non-dendritic network connectivity and a
\code{divergence} attribute must be included. All secondary paths will have the
\code{stream_order} of upstream primary paths and a \code{stream_calculator} value of 0.
Secondary paths have no affect on the order of downstream paths.

Requires a toid attribute or fromnode, tonode, and divergence attributes
that will be used to construct a toid attribute.
}
\examples{
x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

x <- dplyr::select(x, COMID, FromNode, ToNode, Divergence)

x <- add_streamorder(x)

plot(sf::st_geometry(x), lwd = x$stream_order, col = "blue")
plot(sf::st_geometry(x), lwd = x$stream_calculator, col = "blue")

}
