% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize01.R
\name{normalize01}
\alias{normalize01}
\alias{normalize01,matrix-method}
\alias{normalize01,numeric-method}
\alias{normalize01,hyperSpec-method}
\title{normalization for mixed colors}
\usage{
normalize01(x, ...)

\S4method{normalize01}{matrix}(x, tolerance = hy.getOption("tolerance"))

\S4method{normalize01}{numeric}(x, tolerance = hy.getOption("tolerance"))

\S4method{normalize01}{hyperSpec}(x, ...)
}
\arguments{
\item{x}{vector with values to transform}

\item{...}{additional parameters such as \code{tolerance} handed down.}

\item{tolerance}{tolerance level for determining what is 0 and 1}
}
\value{
vector with \code{x} values mapped to the interval [0, 1]
}
\description{
Normalize numbers -> [0, 1]
}
\details{
The input \code{x} is mapped to [0, 1] by subtracting the minimum and subsequently dividing by
the maximum. If all elements of \code{x} are equal, 1 is returned.
}
\seealso{
\code{\link[hyperSpec]{wl.eval}}, \code{\link[hyperSpec]{vanderMonde}}
}
\author{
C. Beleites
}
