\docType{package}
\name{hyperSpec-package}
\alias{hyperSpec-package}
\title{Package hyperSpec}
\description{
  Interface for hyperspectral data sets This package gives
  an interface to handle hyperspectral data sets in R.
  Hyperspectral data are spatially or time-resolved
  spectra, or spectra with any other kind of information
  associated with the spectra. E.g. spectral maps or
  images, time series, calibration series, etc.
}
\details{
  The spectra can be data as obtained in XRF, UV/VIS,
  Fluorescence, AES, NIR, IR, Raman, NMR, MS, etc.

  More generally, any data that is recorded over a
  discretized variable, e.g. absorbance = f (wavelength),
  stored as a vector of absorbance values for discrete
  wavelengths is suitable.
}
\author{
  C. Beleites

  Maintainer: Claudia Beleites <cbeleites@units.it>
}
\seealso{
  \code{citation ("hyperSpec")} produces the correct
  citation.

  \code{package?hyperSpec} for information about the
  package

  \code{class?hyperSpec} for details on the S4 class
  provided by this package.
}
\keyword{package}

