% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap.R
\name{do_lap}
\alias{do_lap}
\title{Linear (sum) assignment problem}
\usage{
do_lap(score, method)
}
\arguments{
\item{score}{matrix of pairwise scores}

\item{method}{One of "lapjv", "lapmod", or "clue"}
}
\value{
\code{do_lap} returns a vector which indicates the
 best matching column for each row.
}
\description{
Compute the best bipartite matching
using one of three methods. For an n x n score matrix it find
\eqn{\max_{v\in \Pi_n} \sum_{i=1}^n score_{i, v(i)}}
where \eqn{\Pi_n} denotes all permutations on n objects.
}
\details{
Solves a linear assignment using one of three methods.
 clue uses solve_lsap from the clue package.
 lapjv uses the Jonker-Volgenaut approach implemented in this package.
 lapmod use a version that exploits sparsity in the score matrix.
}
\examples{
set.seed(12345)
cost <- Matrix::rsparsematrix(10, 10, .5)
cbind(
 do_lap(cost, "lapjv"),
 do_lap(cost, "lapmod"),
 do_lap(cost, "clue")
)

}
