% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_perm.R
\name{get_perm_mat}
\alias{get_perm_mat}
\title{Get Permutation}
\usage{
get_perm_mat(match, dim = NULL, padded = FALSE, seeds = TRUE)
}
\arguments{
\item{match}{Either a graphMatch object or 2-column matrix or data frame.
The first and second columns correspond to indices in \eqn{G_1} and 
\eqn{G_2} respectively.}

\item{dim}{desired dimensions of the matrix. Note, this does not
have to be square. If NULL and match is a graphMatch object then
dim is set to dim(match)}

\item{padded}{If FALSE then this returns a square matrix the size of
the larger of the two graph otherwise dim = dim(match). This is 
ignored if match is not a graphMatch object.}

\item{seeds}{Whether to keep the seed vertices (TRUE) from the match
or to remove them (FALSE). Ignored if match is not a graphMatch object.}
}
\value{
\code{get_perm_mat} returns an \code{m-by-n} sparse permutation matrix or whose
  submatrix is a permutation matrix if only parts of nodes from both graphs get
  matched or in the case of matching graphs of different order.
}
\description{
Get an \code{m-by-n} permutation matrix according to the mapping
  correspondence.
}
\examples{
# returns a permutation matrix: m=n, all the nodes get matched
corr <- data.frame(corr_A = c(1,2,3,4), corr_B = c(1,4,2,3))
get_perm_mat(corr, c(4, 4))

# submatrix is a permutation matrix: parts of graphs get matched
get_perm_mat(corr, c(5, 6))

}
