/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStream;

public class BakerTransformedStream
implements RandomStream {
    private RandomStream st;

    public BakerTransformedStream(RandomStream stream) {
        this.st = stream;
    }

    public void resetStartStream() {
        this.st.resetStartStream();
    }

    public void resetStartSubstream() {
        this.st.resetStartSubstream();
    }

    public void resetNextSubstream() {
        this.st.resetNextSubstream();
    }

    public String toString() {
        return "Baker transformation of " + ((Object)this.st).toString();
    }

    public double nextDouble() {
        double u = this.st.nextDouble();
        if (u > 0.5) {
            return 2.0 * (1.0 - u);
        }
        return u + u;
    }

    public int nextInt(int i, int j) {
        return i + (int)(this.nextDouble() * ((double)(j - i) + 1.0));
    }

    public void nextArrayOfDouble(double[] u, int start, int n) {
        this.st.nextArrayOfDouble(u, start, n);
        for (int i = start; i < start + n; ++i) {
            if (u[i] > 0.5) {
                u[i] = 2.0 * (1.0 - u[i]);
                continue;
            }
            int n2 = i;
            u[n2] = u[n2] + u[i];
        }
    }

    public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
        for (int ii = start; ii < start + n; ++ii) {
            u[ii] = this.nextInt(i, j);
        }
    }
}

