/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.BrownianMotion;

public class BrownianMotionBridge
extends BrownianMotion {
    protected int bridgeCounter = -1;
    protected double[] wMuDt;
    protected double[] wSqrtDt;
    protected int[] wIndexList;
    protected int[] ptIndex;

    public BrownianMotionBridge(double x0, double mu, double sigma, RandomStream stream) {
        super(x0, mu, sigma, stream);
    }

    public BrownianMotionBridge(double x0, double mu, double sigma, NormalGen gen) {
        super(x0, mu, sigma, gen);
    }

    public double nextObservation() {
        double x;
        if (this.bridgeCounter == -1) {
            x = this.x0 + this.mu * (this.t[this.d] - this.t[0]) + this.wSqrtDt[0] * this.gen.nextDouble();
            this.bridgeCounter = 0;
            this.observationIndex = this.d;
        } else {
            int j = this.bridgeCounter * 3;
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            x = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * this.wMuDt[newIndex] + this.wSqrtDt[newIndex] * this.gen.nextDouble();
            ++this.bridgeCounter;
            this.observationIndex = newIndex;
        }
        this.observationCounter = this.bridgeCounter + 1;
        this.path[this.observationIndex] = x;
        return x;
    }

    public double nextObservation(double nextTime) {
        double x;
        if (this.bridgeCounter == -1) {
            this.t[this.d] = nextTime;
            this.wMuDt[0] = 0.0;
            this.wSqrtDt[0] = this.sigma * Math.sqrt(this.t[this.d] - this.t[0]);
            x = this.x0 + this.mu * (this.t[this.d] - this.t[0]) + this.wSqrtDt[0] * this.gen.nextDouble();
            this.bridgeCounter = 0;
            this.observationIndex = this.d;
        } else {
            int j = this.bridgeCounter * 3;
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            this.t[newIndex] = nextTime;
            double dtRL = this.t[oldIndexR] - this.t[oldIndexL];
            this.wMuDt[newIndex] = dtRL != 0.0 ? (this.t[newIndex] - this.t[oldIndexL]) / dtRL : 0.0;
            this.wSqrtDt[newIndex] = this.sigma * Math.sqrt(this.wMuDt[newIndex] * (this.t[oldIndexR] - this.t[newIndex]));
            x = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * this.wMuDt[newIndex] + this.wSqrtDt[newIndex] * this.gen.nextDouble();
            ++this.bridgeCounter;
            this.observationIndex = newIndex;
        }
        this.observationCounter = this.bridgeCounter + 1;
        this.path[this.observationIndex] = x;
        return x;
    }

    public double[] generatePath() {
        this.path[this.d] = this.x0 + this.mu * (this.t[this.d] - this.t[0]) + this.wSqrtDt[0] * this.gen.nextDouble();
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            this.path[newIndex] = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * this.wMuDt[newIndex] + this.wSqrtDt[newIndex] * this.gen.nextDouble();
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        this.path[this.d] = this.x0 + this.mu * (this.t[this.d] - this.t[0]) + this.wSqrtDt[0] * NormalDist.inverseF01(uniform01[0]);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            int oldIndexL = this.wIndexList[j];
            int newIndex = this.wIndexList[j + 1];
            int oldIndexR = this.wIndexList[j + 2];
            this.path[newIndex] = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * this.wMuDt[newIndex] + this.wSqrtDt[newIndex] * NormalDist.inverseF01(uniform01[1 + j / 3]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public void resetStartProcess() {
        this.observationIndex = 0;
        this.observationCounter = 0;
        this.bridgeCounter = -1;
    }

    protected void init() {
        super.init();
        this.wMuDt = new double[this.d + 1];
        this.wSqrtDt = new double[this.d + 1];
        this.wIndexList = new int[3 * this.d];
        this.ptIndex = new int[this.d + 1];
        double tem = 0.0;
        int indexCounter = 0;
        this.ptIndex[0] = 0;
        this.ptIndex[1] = this.d;
        this.wMuDt[0] = 0.0;
        if (this.t[this.d] < this.t[0]) {
            throw new IllegalStateException("   t[d] < t[0]");
        }
        this.wSqrtDt[0] = this.sigma * Math.sqrt(this.t[this.d] - this.t[0]);
        for (int powOfTwo = 1; powOfTwo <= this.d / 2; powOfTwo *= 2) {
            int j;
            for (j = powOfTwo; j >= 1; --j) {
                this.ptIndex[2 * j] = this.ptIndex[j];
            }
            for (j = 1; j <= powOfTwo; ++j) {
                int oldLeft = 2 * j - 2;
                int oldRight = 2 * j;
                int newIndex = (int)(0.5 * (double)(this.ptIndex[oldLeft] + this.ptIndex[oldRight]));
                this.wMuDt[newIndex] = (this.t[newIndex] - this.t[this.ptIndex[oldLeft]]) / (this.t[this.ptIndex[oldRight]] - this.t[this.ptIndex[oldLeft]]);
                tem = (this.t[newIndex] - this.t[this.ptIndex[oldLeft]]) * (this.t[this.ptIndex[oldRight]] - this.t[newIndex]) / (this.t[this.ptIndex[oldRight]] - this.t[this.ptIndex[oldLeft]]);
                if (tem < 0.0 || tem != tem) {
                    System.out.printf("t[newIndex] - t[ptIndex[oldLeft]] = %g%n", this.t[newIndex] - this.t[this.ptIndex[oldLeft]]);
                    System.out.printf("t[ptIndex[oldRight]] - t[newIndex] = %g%n", this.t[this.ptIndex[oldRight]] - this.t[newIndex]);
                    System.out.printf("t[ptIndex[oldRight]] - t[ptIndex[oldLeft]] = %g%n", this.t[this.ptIndex[oldRight]] - this.t[this.ptIndex[oldLeft]]);
                    System.out.printf("t[ptIndex[oldRight]] = %g%n", this.t[this.ptIndex[oldRight]]);
                    System.out.printf("t[ptIndex[oldLeft]] = %g%n", this.t[this.ptIndex[oldLeft]]);
                    throw new IllegalStateException("   tem < 0 or NaN");
                }
                this.wSqrtDt[newIndex] = this.sigma * Math.sqrt(tem);
                this.ptIndex[oldLeft + 1] = newIndex;
                this.wIndexList[indexCounter] = this.ptIndex[oldLeft];
                this.wIndexList[indexCounter + 1] = newIndex;
                this.wIndexList[indexCounter + 2] = this.ptIndex[oldRight];
                indexCounter += 3;
            }
        }
        for (int k = 1; k < this.d; ++k) {
            if (this.ptIndex[k - 1] + 1 >= this.ptIndex[k]) continue;
            this.wMuDt[this.ptIndex[k - 1] + 1] = (this.t[this.ptIndex[k - 1] + 1] - this.t[this.ptIndex[k - 1]]) / (this.t[this.ptIndex[k]] - this.t[this.ptIndex[k - 1]]);
            tem = (this.t[this.ptIndex[k - 1] + 1] - this.t[this.ptIndex[k - 1]]) * (this.t[this.ptIndex[k]] - this.t[this.ptIndex[k - 1] + 1]) / (this.t[this.ptIndex[k]] - this.t[this.ptIndex[k - 1]]);
            if (tem < 0.0 || tem != tem) {
                System.out.printf("t[ptIndex[k-1]+1] - t[ptIndex[k-1]] = %g%n", this.t[this.ptIndex[k - 1] + 1] - this.t[this.ptIndex[k - 1]]);
                System.out.printf("t[ptIndex[k]] - t[ptIndex[k-1]+1] = %g%n", this.t[this.ptIndex[k]] - this.t[this.ptIndex[k - 1] + 1]);
                System.out.printf("t[ptIndex[k]] - t[ptIndex[k-1]] = %g%n", this.t[this.ptIndex[k]] - this.t[this.ptIndex[k - 1]]);
                System.out.printf("t[ptIndex[k]] = %20.16g%n", this.t[this.ptIndex[k]]);
                System.out.printf("t[ptIndex[k-1]] = %20.16g%n", this.t[this.ptIndex[k - 1]]);
                throw new IllegalStateException("   tem < 0 or NaN");
            }
            this.wSqrtDt[this.ptIndex[k - 1] + 1] = this.sigma * Math.sqrt(tem);
            this.wIndexList[indexCounter] = this.ptIndex[k] - 2;
            this.wIndexList[indexCounter + 1] = this.ptIndex[k] - 1;
            this.wIndexList[indexCounter + 2] = this.ptIndex[k];
            indexCounter += 3;
        }
    }
}

