% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.mdn.R
\name{print.mdn}
\alias{print.mdn}
\title{Print Method for Class ``mdn''}
\usage{
\method{print}{mdn}(x, ...)
}
\arguments{
\item{x}{an output from function \code{mdn}}

\item{\dots}{not used.}
}
\description{
\code{print.mdn} is the print utility for the output from function
\code{mdn}
}
\details{
%% ~~ If necessary, more details than the description above ~~ 
The p-value for the mediated effect is displayed as greater or smaller than
\code{sig.level}. For instance, if it is not significant at level 0.05, then
``\code{> 0.05}'' is displayed.
}
\examples{

data("jobs", package = "mediation")

fit.M <- lm(job_seek ~ treat + econ_hard + sex + age, data=jobs)
fit.Y <- lm(depress2 ~ treat + job_seek + econ_hard + sex + age, data=jobs)
mdn(fit.M, fit.Y, "treat")

}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
