% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_levels.R
\name{reorderLevels}
\alias{reorderLevels}
\title{Reorder a categorical}
\usage{
reorderLevels(
  .data,
  var,
  new_levels = NULL,
  freq = FALSE,
  name = sprintf("\%s.reord", var)
)
}
\arguments{
\item{.data}{a dataframe to reorder}

\item{var}{a categorical variable to reorder}

\item{new_levels}{a character vector of the new factor order.
Only specify if \code{freq} = FALSE}

\item{freq}{logical, If \code{freq} = \code{FALSE} (default),
will manually reorder using \code{new_levels}.
If \code{freq} = \code{TRUE}, will reorder
based of descending frequency of the factor levels}

\item{name}{name for the new variable}
}
\value{
original dataframe containing a new column of the reordered
        categorical variable with tidyverse code attached
}
\description{
Reorder the factors of a categorical variable either manually or frequency
}
\examples{
reordered <- reorderLevels(iris, var = "Species",
    new_levels = c("versicolor", "virginica", "setosa"))
cat(code(reordered))
head(reordered)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
