% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_levels.R
\name{renameLevels}
\alias{renameLevels}
\title{Rename the levels of a categorical variable}
\usage{
renameLevels(.data, var, to_be_renamed, name = sprintf("\%s.rename", var))
}
\arguments{
\item{.data}{a dataframe with the column to be renamed}

\item{var}{a character of the categorical variable to rename}

\item{to_be_renamed}{a list of the old level name assigned
to the new level name;
i.e., `list('new level name' = 'old level name')`}

\item{name}{a name for the new variable}
}
\value{
original dataframe containing a new column of the renamed categorical
        variable with tidyverse code attached
}
\description{
Rename the levels of a categorical variables, and returns the result
along with tidyverse code used to generate it.
}
\examples{
renamed <- renameLevels(iris, var = "Species",
    to_be_renamed = list(set = "setosa", ver = "versicolor"))
cat(code(renamed))
head(renamed)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
