% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewardestimation.R
\name{fit_predict.numeric_reward_estimator}
\alias{fit_predict.numeric_reward_estimator}
\title{Fit a numeric reward estimator on features, treatments and
outcomes and return predicted counterfactual rewards for each observation,
under each treatment candidate, as well as the scores of the internal
estimators.}
\usage{
\method{fit_predict}{numeric_reward_estimator}(obj, X, treatments, ...)
}
\arguments{
\item{obj}{The learner or grid to use for estimation}

\item{X}{The features of the data.}

\item{treatments}{The treatment applied to each point in the data.}

\item{...}{Additional arguments depending on the treatment and outcome types.
Refer to the Julia documentation for more information.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.1/RewardEstimation/reference/#IAI.fit_predict\%21-Tuple\%7BNumericRewardEstimator\%7D}{\code{IAI.fit_predict!}}
}
\section{IAI Compatibility}{

Requires IAI version 2.1 or higher.
}

\examples{
\dontrun{iai::fit_predict(obj, X, treatments, outcomes)}

}
