% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaitrees.R
\name{get_regression_constant}
\alias{get_regression_constant}
\title{Return the constant term in the regression prediction at a node of a tree}
\usage{
get_regression_constant(lnr, node_index, ...)
}
\arguments{
\item{lnr}{The learner to query.}

\item{node_index}{The node in the tree to query.}

\item{...}{If a prescription problem, the treatment to query.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v1.2.0/IAITrees/reference/#IAITrees-API-Reference-1}{\code{IAI.get_regression_constant}}
(for regression or prescription tree learners as appropriate)
}
\examples{
\dontrun{
iai::get_regression_constant(lnr, 1)
iai::get_regression_constant(lnr, 1, "A")
}

}
