% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaitrees.R
\name{similarity_comparison}
\alias{similarity_comparison}
\title{Conduct a similarity comparison between the final tree in a learner and
all trees in a new learner to consider the tradeoff between training
performance and similarity to the original tree}
\usage{
similarity_comparison(lnr, new_lnr, deviations)
}
\arguments{
\item{lnr}{The original learner}

\item{new_lnr}{The new learner}

\item{deviations}{The deviation between the original tree and each tree in
the new learner}
}
\description{
Refer to the
\href{https://docs.interpretable.ai/v3.0.0/IAITrees/stability/#Tree-Stability-1}{documentation on tree stability}
for more information.
}
\details{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.0.0/IAITrees/reference/#IAI.SimilarityComparison}{\code{SimilarityComparison}}
}
\section{IAI Compatibility}{

Requires IAI version 2.2 or higher.
}

\examples{
\dontrun{iai::similarity_comparison(lnr, new_lnr, deviations)}

}
