% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{partgam_LD}
\alias{partgam_LD}
\title{Partial Gamma to detect Local Dependence (LD)}
\usage{
partgam_LD(dat.items)
}
\arguments{
\item{dat.items}{A data frame with the responses to the items.}
}
\value{
data frame with Gamma coefficients, standard errors, p values and confidence limits for every
pair of items.
}
\description{
Rasch models assume locally independent items. There should be no substantial correlation left between two items
once the underlying factor has been taken into account.
Partial Gamma coefficients between pairs of items controlled for the rest score
can be used to assess this requirement.
}
\examples{
partgam_LD(amts[,4:13])
}
\references{
Christensen, K. B. , Kreiner, S. & Mesbah, M. (Eds.)
\emph{Rasch Models in Health}. Iste and Wiley (2013), pp. 133 - 135.
}
\seealso{
\code{\link{partgam_DIF}}
}
\author{
Marianne Mueller
}
