% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_packages.R
\name{get_cran_history}
\alias{get_cran_history}
\title{History of the Number of Available CRAN Packages}
\usage{
get_cran_history()
}
\value{
a tibble with columns \code{date} and \code{n_packages}
}
\description{
Get a data frame containing the number of packages available for historic
dates back to 21 June 2001.
}
\details{
Data on the number of packages on CRAN between 2001-06-21 and 2014-04-13
is obtained from \code{\link[Ecdat:CRANpackages]{Ecdat::CRANpackages}}.
This data was collected by John Fox and Spencer Graves. Intervals between
data points are irregularly spaced.

Newer data was obtained using the function \code{\link[=n_available_packages]{n_available_packages()}} which
extracts the information from CRAN snapshots on MRAN. One data point per
quarter is available starting on 2014-10-01.
}
\examples{
library(ggplot2)
cran_history <- get_cran_history()
ggplot(cran_history, aes(x = date, y = n_packages)) +
  geom_point()

}
