% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icrsf.r
\name{icrsf}
\alias{icrsf}
\title{Permutation-based variable importance metric for high dimensional datasets appropriate for time to event outcomes,
in the presence of imperfect self-reports or laboratory-based diagnostic tests.}
\usage{
icrsf(data, subject, testtimes, result, sensitivity, specificity, Xmat,
  root.size, ntree, ns, node, pval = 1)
}
\arguments{
\item{data}{name of the data frame that includes the variables subject, testtimes, result}

\item{subject}{vector of subject IDs of length N**x1.}

\item{testtimes}{vector of visit or test times of length N**x1.}

\item{result}{vector of binary diagnostic test results (0 = negative for event of interest; 1 = positive
for event of interest) of length N**x1.}

\item{sensitivity}{the sensitivity of the diagnostic test}

\item{specificity}{the specificity of the diagnostic test}

\item{Xmat}{a N x P matrix of covariates.}

\item{root.size}{minimum number of subjects in a terminal node.}

\item{ntree}{number of survival trees.}

\item{ns}{number of covariate selected at each node to split the tree.}

\item{node}{For parallel computation, specify the number of nodes.}

\item{pval}{P-value threshold of the Likelihood Ratio Test.}
}
\value{
a vector of the ensembled variable importance for modified random survival forest (icRSF).
}
\description{
Let N and P denote the number of subjects and number of variables in the dataset, respectively.
             Let N** denote the total number of visits, summed over all subjects in the study
             [i.e. N** denotes the number of diagnostic test results available for all subjects in the study].
              This algorithm builds a user-defined number of survival trees, using bootstrapped datasets.
              Using the out of bag (OOB) data in each tree, a permutation-based measure of
              variable importance for each of the P variables is obtained.
}
\examples{
library(parallel)
data(Xmat)
data(pheno)
vimp <- icrsf(data=pheno, subject=ID, testtimes=time, result=result, sensitivity=1,
             specificity=1, Xmat=Xmat, root.size=30, ntree=1, ns=sqrt(ncol(Xmat)), node=1, pval=)

}
