% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{iccTraj}
\alias{iccTraj}
\title{Estimates the intraclass correlation coefficient (ICC) for trajectory data}
\usage{
iccTraj(
  data,
  ID,
  trip,
  LON,
  LAT,
  time,
  projection = CRS("+proj=longlat"),
  origin = "1970-01-01 UTC",
  parallel = TRUE,
  individual = TRUE,
  distance = c("H", "F"),
  bootCI = TRUE,
  nBoot = 100,
  q = 0.5
)
}
\arguments{
\item{data}{A data frame with the locations and times of trajectories. It is assumed the time between locations is uniform. It must contain at least five columns: subject identifier, trip identifier, latitude, longitude, and time of the reading.}

\item{ID}{Character string indicating the name of the subjects column in the dataset.}

\item{trip}{Character string indicating the trip column in the dataset.}

\item{LON}{Numeric. Longitude readings.}

\item{LAT}{Numeric. Latitude readings.}

\item{time}{Numeric. Time of the readings.}

\item{projection}{Projection string of class CRS-class.}

\item{origin}{Optional. Origin of the date-time. Only needed in the internal process to create an object of type POSIXct.}

\item{parallel}{TRUE/FALSE value. Use parallel computation? Default value is TRUE.}

\item{individual}{TRUE/FALSE value. Compute individual within-subjects variances? Default value is TRUE.}

\item{distance}{Metric used to compute the distances between trajectories. Options are **H** for median Hausforff distance, and **F** for discrete Fréchet distance.}

\item{bootCI}{TRUE/FALSE value. If TRUE it will generate boostrap resamples. Default value is TRUE.}

\item{nBoot}{Numeric. Number of bootstrap resamples. Ignored if \code{"bootCI"} is FALSE. Default value is 100.}

\item{q}{Quantile for the extended Hausdorff distance. Default value q=0.5 leads to median Hausdorff distance.}
}
\value{
An object of class *iccTraj*.The output is a list with the following components:
\itemize{
  \item *est*. Data frame with the following estimates: the ICC (r), the subjects' mean sum-of-squares (MSA), the between-subjects variance (sb), the total variance (st), and the within-subjects variance (se).
  \item *boot*. If bootCI argument is set to TRUE, data frame with the bootstrap estimates.
  \item *D*. Data frame with the pairwise distances among trajectories.
  \item *indW* Data frame with the follwoing columns: the subject's identifier (ID), the individual within-subjects variances (w), and the number of trips (n).
}
}
\description{
Estimates the intraclass correlation coefficient (ICC) for trajectory data
}
\details{
The intraclass correlation coefficient is estimated using the distance matrix among trajectories.

Bootstrap resamples are obtained using balanced randomized cluster bootstrap approach (Davison and Hinkley, 1997; Field and Welsh, 2007)
}
\examples{
\donttest{
# Using median Hausdorff distance.
 Hd<-iccTraj(gull_data,"ID","trip","LONG","LAT","triptime")
 Hd$est
# Using discrete Fréchet distance.
Fd<-iccTraj(gull_data,"ID","trip","LONG","LAT","triptime", distance="F")
Fd$est
}
}
\references{
{

Davison A.C., Hinkley D.V. (1997). Bootstrap Methods and Their Application. Cambridge: Cambridge University Press.

Field, C.A., Welsh, A.H. (2007). Bootstrapping Clustered Data. Journal of the Royal Statistical Society. Series B (Statistical Methodology). 69(3), 369-390.

}
}
