% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr.R
\name{as.decimal_diag}
\alias{as.decimal_diag}
\alias{as.icd_decimal_diag}
\alias{as.short_diag}
\alias{as.icd_short_diag}
\alias{is.decimal_diag}
\alias{is.icd_decimal_diag}
\alias{is.short_diag}
\alias{is.icd_short_diag}
\title{Get or set whether ICD codes have have an attribute indicating 'short' or
'decimal' format}
\usage{
as.decimal_diag(x, value = TRUE)

as.icd_decimal_diag(x, value = TRUE)

as.short_diag(x, value = TRUE)

as.icd_short_diag(x, value = TRUE)

is.decimal_diag(x)

is.icd_decimal_diag(x)

is.short_diag(x)

is.icd_short_diag(x)
}
\arguments{
\item{x}{ICD data}

\item{value}{\code{TRUE} or \code{FALSE}, default is \code{TRUE} which sets
the attribute to whatever is indicated in the function name. See examples.}
}
\description{
Get or set whether ICD codes have have an attribute indicating 'short' or
'decimal' format
}
\section{Getting the attribute}{
 \code{is.short_diag} tests for presence of an
  attribute, not whether the code is a valid ICD code. To test validity of
  the codes themselves, see \code{\link{is_valid}}.
}

\section{Setting the attribute}{
 Similarly, \code{as.icd_short_diag} and
  \code{as.icd_decimal_diag} set the attribute, but do not convert the codes
  themselves. For conversion between 'short' and 'decimal' forms, use
  \code{\link{decimal_to_short}} and \code{\link{short_to_decimal}}.

  The attribute \code{icd_short_code} should be either \code{TRUE} or
  \code{FALSE}. There is no attribute named \code{icd_decimal_code}. These
  functions set and get the attribute safely. If the attribute is not
  present, both \code{is.icd_short_diag} and \code{is.icd_decimal_diag} (or
  their synonyms \code{is.short_diag} and \code{is.decimal_diag}) will return
  \code{FALSE}.
}

\examples{
library(icd)
as.icd_short_diag("6670")
as.icd_short_diag("667.0") # no warning or error!
is.icd_short_diag(decimal_to_short("667.0"))
decimal_type_code <- as.icd_short_diag("667.0", FALSE)
stopifnot(is.icd_decimal_diag(decimal_type_code))
codes <- as.icd9(c("100.1", "441.3"))
codes <- as.decimal_diag(codes)
codes
}
