% Generated by roxygen2 (4.0.1): do not edit by hand
\name{parseAhrqSas}
\alias{parseAhrqSas}
\title{parse AHRQ data}
\usage{
parseAhrqSas(sasPath = system.file("extdata", "comformat2012-2013.txt",
  package = "icd9"), save = FALSE, saveDir = "~/icd9/data",
  returnAll = FALSE)
}
\arguments{
\item{sasPath}{single character string containing path to SAS FORMAT
definition code.}

\item{save}{logical, whether to try to save the output data in the source
tree.}

\item{saveDir}{character vector of unit length containing path to the source
package data directory. Default is ~/icd9/data}

\item{returnAll}{logical which, if TRUE, will result in the invisible return of ahrqComorbidAll result, otherwise, ahrqComorbid is reutrned.}
}
\value{
list of lists, name value pairs, and where a single name was
  associated with multiple further name-value pairs, this is presented as a
  sub-list. This is primarily required because of the obtuse SAS FORMAT data
  structure: the AHRQ codes are hidden in a sublist of the first item.
}
\description{
Takes the raw data taken directly from the AHRQ web site and
  parses into RData. It is then saved in the development tree data directory,
  so this is an internal function, used in generating the package itself!
}
\keyword{internal}

