% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9AddLeadingZeroes}
\alias{icd9AddLeadingZeroes}
\alias{icd9AddLeadingZeroesDecimal}
\alias{icd9AddLeadingZeroesMajor}
\alias{icd9AddLeadingZeroesShort}
\title{pad decimal ICD-9 codes with leading zeroes}
\usage{
icd9AddLeadingZeroes(icd9, isShort, addZeroV = FALSE,
  invalidAction = icd9InvalidActions)

icd9AddLeadingZeroesDecimal(icd9Decimal, addZeroV = FALSE,
  invalidAction = icd9InvalidActions)

icd9AddLeadingZeroesShort(icd9Short, addZeroV = FALSE,
  invalidAction = icd9InvalidActions)

icd9AddLeadingZeroesMajor(major, addZeroV = FALSE,
  invalidAction = icd9InvalidActions)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{addZeroV}{single logical whether to add zeros to V codes, default being
not to do so. E codes are always E800-E999 (if valid) so no attempt is ever
made to zero-pad them as it would just make invalid codes even worse.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\value{
character vector of icd9 codes
}
\description{
pad decimal ICD-9 codes with leading zeroes

Non-decimal ICD-9 codes with length<5 are often ambiguous. E.g.
  100 could be 1.00 10.0 or 100

three digit codes are returned unchanged, one and two digit
  codes are preceded by 00 or 0. V codes are only zero padded if addZeroV is set to TRUE.
}
\keyword{internal}
\keyword{manip}

