% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R, R/RcppExportsShim.R
\name{icd9AddLeadingZeroesShort}
\alias{icd9AddLeadingZeroes}
\alias{icd9AddLeadingZeroesDecimal}
\alias{icd9AddLeadingZeroesMajor}
\alias{icd9AddLeadingZeroesShort}
\title{Add leading zeroes to incomplete ICD codes}
\usage{
icd9AddLeadingZeroesShort(icd9Short)

icd9AddLeadingZeroesDecimal(icd9Decimal)

icd9AddLeadingZeroes(icd9, isShort)

icd9AddLeadingZeroesMajor(major)
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9}{is
a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{major}{character vector of 'major' part of ICD-9 codes, i.e. that part
which falls before the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be the first three characters (with leading
zeroes), and includes V or E prefix. xyz}
}
\value{
character vector of ICD codes (or major part thereof)
}
\description{
Non-decimal ICD-9 codes with length<5 are often ambiguous. E.g.
  100 could be 1.00 10.0 or 100 if coded incorrectly. We must assume 100 is
  really 100
}
\keyword{internal}
\keyword{manip}

