% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_utilities.R
\name{survCIs}
\alias{survCIs}
\title{Confidence/Credible intervals for survival curves}
\usage{
survCIs(fit, newdata, p = c(0:9 * 0.1 + 0.05), ci_level = 0.95,
  MC_samps = 40000)
}
\arguments{
\item{fit}{Fitted model from \code{ic_par} or \code{ic_bayes}}

\item{newdata}{\code{data.frame} containing covariates for survival curves}

\item{p}{Percentiles of distribution to sample}

\item{ci_level}{Confidence/credible level}

\item{MC_samps}{Number of Monte Carlo samples taken}
}
\description{
Confidence/Credible intervals for survival curves
}
\details{
Creates a set of confidence intervals for the survival curves conditional
on the covariates provided in \code{newdata}. Several rows can be provided in newdata;
this will lead to several sets of confidence/credible intervals. 

For Bayesian models, these are draws directly from the posterior; a set of parameters drawn 
from those saved in \code{fit$samples} repeatedly and then for each set of parameters, 
the given set of quantiles is calculated. For parametric models, the procedure is virtually the 
same, but rather than randomly drawing rows from saved samples, random samples are drawn using
the asymptotic normal approximation of the estimator. 

This function is not compatible with \code{ic_np} or \code{ic_sp} objects, as the distribution 
of the baseline distribution of these estimators is still an open question.
}
\examples{
data("IR_diabetes")
fit <- ic_bayes(cbind(left, right) ~ gender, 
                data = IR_diabetes)

# Getting credible intervals for survival curves
# for males and females
newdata <- data.frame(gender = c("male", "female"))
rownames(newdata) <- c("Males", "Females")
diab_cis <- survCIs(fit, newdata)
diab_cis

# Can add this to any plot
plot(fit, newdata = newdata, 
     cis = FALSE)
# Would have been included by default
lines(diab_cis, cols = c("black", "red"))
}
\author{
Clifford Anderson-Bergman
}
