% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_utilities.R
\name{diag_baseline}
\alias{diag_baseline}
\title{Compare parametric baseline distributions with semi-parametric baseline}
\usage{
diag_baseline(object, data, model = "ph", weights = NULL,
  dists = c("exponential", "weibull", "gamma", "lnorm", "loglogistic",
  "generalgamma"), cols = NULL, lgdLocation = "bottomleft",
  useMidCovars = T)
}
\arguments{
\item{object}{Either a formula or a model fit with \code{ic_sp} or \code{ic_par}}

\item{data}{Data. Unnecessary if \code{object} is a fit}

\item{model}{Type of model. Choices are \code{'ph'} or \code{'po'}}

\item{weights}{Case weights}

\item{dists}{Parametric baseline fits}

\item{cols}{Colors of baseline distributions}

\item{lgdLocation}{Where legend will be placed. See \code{?legend} for more details}

\item{useMidCovars}{Should the distribution plotted be for covariates = mean values instead of 0}
}
\description{
Creates plots to diagnosis fit of different choices of parametric baseline model. 
Plots the semi paramtric model against different choices of parametric models.
}
\details{
If \code{useMidCovars = T}, then the survival curves plotted are for fits with the mean covariate value, 
rather than 0. This is because often the baseline distribution (i.e. with all covariates = 0) will be 
far away from the majority of the data.
}
\examples{
data(IR_diabetes)
fit <- ic_par(cbind(left, right) ~ gender, 
             data = IR_diabetes)

diag_baseline(fit, lgdLocation = "topright", 
             dist = c("exponential", "weibull", "loglogistic"))

}
\author{
Clifford Anderson-Bergman
}
