% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icpower_weibull.R
\name{icpower_weibull}
\alias{icpower_weibull}
\title{Study design in the presence of error-prone diagnostic tests and 
self-reported outcomes for Weibull model}
\usage{
icpower_weibull(
  HR,
  sensitivity,
  specificity,
  shape,
  scale,
  times,
  N = NULL,
  power = NULL,
  rho = 0.5,
  alpha = 0.05,
  pmiss = 0,
  pcensor = 0,
  design = "MCAR",
  negpred = 1
)
}
\arguments{
\item{HR}{hazard ratio under the alternative hypothesis.}

\item{sensitivity}{the sensitivity of test.}

\item{specificity}{the specificity of test}

\item{shape}{shape parameter of the Weibull distribution for reference group}

\item{scale}{scale parameter of the Weibull distributions. Same for all groups}

\item{times}{the visit times}

\item{N}{a vector of sample sizes to calculate corresponding powers. If one 
needs to calculate sample size, then set to NULL.}

\item{power}{a vector of powers to calculate corresponding sample sizes. If 
one needs to calculate power, then set to NULL.}

\item{rho}{proportion of subjects in baseline(reference) group.}

\item{alpha}{type I error.}

\item{pmiss}{a value or a vector (must have same length as survivals) of the 
probabilities of each test being randomly missing at each test time. If 
pmiss is a single value, then each test is assumed to have an identical 
probability of missingness.}

\item{pcensor}{a value or a vector (must have same length as testtimes) of
the probability of censoring at each visit, assuming censoring process
is independent on other missing mechanisms.}

\item{design}{missing mechanism: "MCAR" or "NTFP".}

\item{negpred}{baseline negative predictive value, i.e. the probability of 
being truely disease free for those who were tested (reported) as disease 
free at baseline. If baseline screening test is perfect, then negpred = 1.}
}
\value{
\itemize{ \item result: a data frame with calculated sample size and 
  power \item I1 and I2: calculated unit Fisher information matrices for each
  group, which can be used to calculate more values of sample size and power 
  for the same design without the need to enumerate again }
}
\description{
This functions works same way as \code{\link{icpower}} function 
except that it assumes the survival function follows Weibull
distribution. The scale parameter is assumed to be same for
both treatment and control groups.
This can be used estimate power and sample size for interval
censored data using Weibull model, which is a cpecial case
when both sensitivity and specificity being 1.
}
\details{
To calculate sample sizes for a vector of powers, set N = NULL. To 
  calculate powers for a vector of sample sizes, set power = NULL. One and 
  only one of power and N should be specified, and the other set to NULL. 
  This function uses an enumeration algorithm to calculate the expected 
  Fisher information matrix. The expected Fisher information matrix is used 
  to obtain the variance of the coefficient corresponding to the treatment 
  group indicator.
}
\note{
When diagnostic test is perfect, i.e. sensitivity=1 and 
  specificity=1, use \code{\link{icpowerpf}} instead to obtain significantly 
  improved computational efficiency.
}
\examples{

icpower_weibull(2, 0.75, 0.98, 1, 0.1, 1:8, power = 0.9)$result

# Interval censoring
icpower_weibull(2, 1, 1, 1, 0.1, 1:8, power = 0.9)$result

}
\seealso{
\code{\link{icpowerpf}} \code{\link{icpower}}
}
