% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp.R
\name{cp}
\alias{cp}
\title{Copy Files}
\usage{
cp(from, to, move = FALSE)
}
\arguments{
\item{from}{source filenames, e.g. \code{*.csv}.}

\item{to}{destination filenames, or directory.}

\item{move}{whether to move instead of copy.}
}
\value{
\code{TRUE} for success, \code{FALSE} for failure, invisibly.
}
\description{
Copy or move files, overwriting existing files if necessary, and returning
the result invisibly.
}
\examples{
\dontrun{
write(pi, "A.txt")
cp("A.txt", "B.txt")
cp("A.txt", "B.txt", move=TRUE)

## Copy directory tree
cp(system.file(package="datasets"), ".")
mkdir("everything")
cp("datasets/*", "everything")
}

}
\seealso{
\code{\link{file.copy}} and \code{\link{unlink}} are the underlying functions
used to copy and (if \code{move = TRUE}) delete files.

\code{\link{icesTAF-package}} gives an overview of the package.
}
