test_that("archive functions ok", {
  skip_if_not_installed("openssl")
  cloud <- ichimoku(sample_ohlc_data)
  archive(cloud, file <- tempfile())
  restored <- archive(file)
  unlink(file)
  expect_identical(restored, cloud)
  expect_error(archive(), "is used to")
  expect_error(archive(cloud, cloud, cloud), "Too many arguments")
  expect_error(archive(cloud), "supplied as a string")
  expect_error(archive(cloud, cloud), "supplied as a string")
  expect_error(archive(object = cloud), "specified without")
  file <- tempfile()
  save(sample_ohlc_data, file = file)
  expect_error(archive(file = file), "was not created")
  unlink(file)
  file <- tempfile()
  save(cloud, x_archive_sha256, file = file)
  expect_message(archive(file), "unverified")
  unlink(file)
  x_archive_sha256 <- "010101010101"
  file <- tempfile()
  save(cloud, x_archive_sha256, file = file)
  expect_warning(archive(file), "does not match the original")
  unlink(file)
})
