% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{index}
\alias{index}
\alias{index.ichimoku}
\title{Extract the Index of Ichimoku Objects}
\usage{
\method{index}{ichimoku}(x, ...)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{...}{arguments passed to or from other methods.}
}
\value{
The date-time index of the ichimoku object as a vector of POSIXct
    values.
}
\description{
Method for extracting the date-time index of ichimoku objects.
}
\details{
This function is an S3 method for the generic function index()
    for class 'ichimoku'. It can be invoked by calling index(x) on an
    object 'x' of class 'ichimoku'.

    For further details please refer to the reference vignette by calling:
    \code{vignette("reference", package = "ichimoku")}
}
\examples{
cloud <- ichimoku(sample_ohlc_data)
index(cloud)[101:120]

}
