% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.r
\docType{methods}
\name{gridlabs3d}
\alias{gridlabs3d}
\alias{gridlabs3d,}
\alias{gridlabs3d,hexagrid-method}
\alias{gridlabs3d,trigrid-method}
\alias{gridlabs3d-hexagrid-method}
\alias{gridlabs3d-trigrid-method}
\title{Display the names of the grid elements in 3d plots.}
\usage{
gridlabs3d(gridObj, ...)

\S4method{gridlabs3d}{trigrid}(gridObj, type = "f", ...)

\S4method{gridlabs3d}{hexagrid}(gridObj, type = "f", ...)
}
\arguments{
\item{gridObj}{A \code{trigrid} or \code{hexagrid} object to be plotted.}

\item{...}{further arguments passed to \code{text3d} of the rgl package.}

\item{type}{A character vector containing either "f", "e" or "v", rendering the names
of either the faces, edges or vertives respectively.}
}
\value{
The function does not return any value.
}
\description{
This function will display the names of vertices, faces and edges on 3d plots.
}
\examples{
# create a hexagonal grid
    g <- hexagrid(c(2,2))
# plot the grid in 3d space
   plot3d(g, guides=FALSE)
# plot the names of the faces
		gridlabs3d(g, type="f", col="red")
# plot the names of the vertices
    gridlabs3d(g, type="v", col="blue", cex=0.6)
}

