% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImpPlot.R
\name{varImpPlot.icrf}
\alias{varImpPlot.icrf}
\alias{varImpPlot}
\title{'Variable Importance Plot'}
\usage{
varImpPlot(x, ...)

\method{varImpPlot}{icrf}(x, sort = TRUE, n.var = min(30,
  nrow(x$importance)), type = NULL, forest = NULL,
  main = deparse(substitute(x)), ...)
}
\arguments{
\item{x}{'an object of class' \code{icrf}}

\item{...}{'Other graphical parameters to be passed on to \code{dotchart}.'}

\item{sort}{'Should the variables be sorted in decreasing order of importance?'}

\item{n.var}{'How many variables to show? (Ignored if sort=FALSE.)'}

\item{type}{'arguments to be passed on to importance'}

\item{forest}{The forest for which the importance is plotted. If \code{NULL},
the best forest is plotted.}

\item{main}{'plot title'}
}
\value{
'Invisibly, the importance of the variables that were plotted.'
}
\description{
'Dotchart of variable importance as measured by' \code{icrf}.
(Quoted statements are from
\code{randomForest} by Liaw and Wiener unless otherwise mentioned.)
}
\examples{
# rats data example.
# Note that this is a toy example. Use a larger ntree and nfold in practice.
data(rat2)
\donttest{
 set.seed(1)
 rats.icrf <-
   icrf(~ dose.lvl + weight + male + cage.no, data = rat2,
        data.type = "currentstatus", currentstatus.label = c("survtime", "tumor"),
        returnBest = TRUE, ntree=10, nfold=3)
 varImpPlot(rats.icrf)
}
\dontshow{
 set.seed(1)
 rats.icrf <-
   icrf(~ dose.lvl + weight + male + cage.no, data = rat2,
        data.type = "currentstatus", currentstatus.label = c("survtime", "tumor"),
        returnBest = TRUE, ntree=2, nfold=2)
 varImpPlot(rats.icrf)
}

}
\references{
\href{https://arxiv.org/abs/1912.09983}{Cho H., Jewell N. J., and Kosorok M. R. (2020+). "Interval censored
 recursive forests"}
}
\author{
Hunyong Cho, Nicholas P. Jewell, and Michael R. Kosorok.
}
