% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNameChrDfMarks.R
\name{checkNameChrDfMarks}
\alias{checkNameChrDfMarks}
\title{Function to check names of OTUs (species) among dataframes}
\usage{
checkNameChrDfMarks(dfChrSize, dfMarks)
}
\arguments{
\item{dfChrSize}{dataframe, with columns: OTU (optional), chrName, for chr.
with cen.: shortArmSize, longArmSize, for holoc.: chrSize}

\item{dfMarks}{dataframe, of marks (sites): OTU (opt / mandat. if in
dfChrSize), chrName markName markSize, for chr. with cen.:  markArm (p,q)
markDistCen, for holoc: markPos}
}
\value{
logical
}
\description{
This function reads two dataframes the one with chromosome sizes, and one df
with data of marks (sites) both have to have the column \code{chrName} and if
several species, \code{OTU}. The functions returns \code{TRUE} if names of
chromosomes in dataframe of marks are included in dataframe of chr. size.
}
\examples{
data(dfOfChrSize,dfOfMarks,dfOfCenMarks)
checkNameChrDfMarks(dfOfChrSize,dfOfMarks)
checkNameChrDfMarks(dfOfChrSize,dfMarks=dfOfCenMarks)
}
\keyword{check}
\keyword{dataframe}
