% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citrusSize.R
\name{citrusSize}
\alias{citrusSize}
\alias{citrusMarkPos,}
\alias{markOverCMA}
\alias{citrusMarkPos}
\title{FUNCTIONS: citrusSize, citrusMarkPos, markOverCMA}
\usage{
citrusSize(
  A = 0,
  B = 0,
  C = 0,
  D = 0,
  E = 0,
  F = 0,
  FL = 0,
  FL0 = 0,
  G = 0,
  shortArm = 1.2,
  longArm = 1.7,
  shortArmFL = 1.3,
  longArmFL = 1.8,
  OTU = "OTU 1"
)

citrusMarkPos(
  chrSizeDf,
  mSizePter = 0.25,
  mSizeQter = 0.35,
  mSizePprox = 0.35,
  mOther = 0.25,
  markName = "CMA"
)

markOverCMA(
  citrusMarkPosDF,
  chrType = "B",
  chrName,
  chrRegion = "p",
  markName = "45S"
)
}
\arguments{
\item{A}{number of A to calculate (citrusSize)}

\item{B}{number of B to calculate (citrusSize)}

\item{C}{number of C to calculate (citrusSize)}

\item{D}{number of D to calculate (citrusSize)}

\item{E}{number of E to calculate (citrusSize)}

\item{F}{number of F to calculate (citrusSize)}

\item{FL}{number of FL to calculate (citrusSize)}

\item{FL0}{number of FL0 to calculate (citrusSize)}

\item{G}{number of G to calculate (citrusSize)}

\item{shortArm}{for A to G (not FL) (citrusSize)}

\item{longArm}{for A to G (not FL) (citrusSize)}

\item{shortArmFL}{for FL (citrusSize)}

\item{longArmFL}{for FL (citrusSize)}

\item{OTU}{name of species (citrusSize)}

\item{chrSizeDf}{data.frame created with \code{citrusSize} function (citrusMarkPos)}

\item{mSizePter}{numeric, default size for P(short) ter (terminal) bands. \code{0.25} (default) (citrusMarkPos)}

\item{mSizeQter}{numeric, default size for Q(long) ter (terminal) bands. \code{0.35} (default) (citrusMarkPos)}

\item{mSizePprox}{numeric, default size for P prox (proximal) bands. \code{0.35} (default) (citrusMarkPos)}

\item{mOther}{numeric, default size for other bands. \code{0.25} (default) (citrusMarkPos)}

\item{markName}{character, default name of mark \code{"CMA"}, or \code{"45S"}, respectively. (citrusMarkPos,markOverCMA)}

\item{citrusMarkPosDF}{data.frame, with CMA marks (markOverCMA)}

\item{chrType}{character, defaults to "B", chr. type to duplicate mark (markOverCMA)}

\item{chrName}{character, defaults to "B", chr. name to duplicate mark (markOverCMA)}

\item{chrRegion}{character, arm, defaults to "p". for mark duplication (markOverCMA)}
}
\value{
data.frame

data.frame

data.frame
}
\description{
Helper function to create data.frames with
chr. size and mark size data for Citrus
based on categories in Carvalho et al. (2005)
}
\examples{
citrusSizeDF <- citrusSize(B=1,D=11,F=4,FL0=2,OTU="C. jambhiri")

citrusMarkPosDF <- citrusMarkPos(citrusSizeDF)
citrusMarkPosDF45S<-markOverCMA(citrusMarkPosDF, chrType="B", chrRegion="p", markName="45S")
}
\references{
Carvalho, R., Soares Filho, W. S., Brasileiro-Vidal, A. C., & Guerra, M. (2005). The relationships among lemons, limes and citron: A chromosomal comparison. Cytogenetic and Genome Research, 109(1–3), 276–282. https://doi.org/10.1159/000082410
}
\keyword{arm}
\keyword{size}
