% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/required_parameters.R
\name{required_parameters}
\alias{required_parameters}
\title{Lookup the Details of Parameters Required by a Model}
\usage{
required_parameters(model = NULL)
}
\arguments{
\item{model}{A character string containing the name of the model of interest. Defaults to \code{NULL}.}
}
\value{
A dataframe extracted from \code{\link[idmodelr]{parameter_details}} containing the details of the parameters
required by the model of interest.
}
\description{
This function simplifies the process of checking which parameters a given \code{idmodelr} model depends on.
It is effectively an interface to \code{\link[idmodelr]{parameter_details}} via \code{\link[idmodelr]{model_details}}. As
fuzzy matching has been used it can also given information of the parameter requirements of a subset of the available models.
}
\examples{

## Check the parameters required by the "SIR_ode" model
required_parameters("SIR_ode")


## Use fizzy matching to look at paramters for all SIR models
required_parameters("SIR")
}
