% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Manningtrap.R
\encoding{UTF-8}
\name{Manningtrap_critical}
\alias{Manningtrap_critical}
\title{Trapezoidal cross-section for the Gauckler-Manning-Strickler equation (critical parameters)}
\usage{
Manningtrap_critical(
  Q = NULL,
  n = NULL,
  m = NULL,
  m1 = NULL,
  m2 = NULL,
  Sf = NULL,
  y = NULL,
  b = NULL,
  Temp = NULL,
  units = c("SI", "Eng"),
  type = c("symmetrical", "non-symmetrical"),
  critical = c("approximate", "accurate"),
  output = c("list", "data.table")
)
}
\arguments{
\item{Q}{numeric vector that contains the discharge value (m^3/s or ft^3/s),
if known.}

\item{n}{numeric vector that contains the Manning's roughness coefficient n,
if known.}

\item{m}{numeric vector that contains the symmetric "cross-sectional side slope
of m:V (horizontal:vertical)", if known.}

\item{m1}{numeric vector that contains the non-symmetric "cross-sectional side
slope of m1:V (horizontal:vertical)", if known.}

\item{m2}{numeric vector that contains the non-symmetric "cross-sectional side
slope of m2:V (horizontal:vertical)", if known.}

\item{Sf}{numeric vector that contains the bed slope (m/m or ft/ft),
if known.}

\item{y}{numeric vector that contains the flow depth (m or ft), if known.}

\item{b}{numeric vector that contains the bottom width, if known.}

\item{Temp}{numeric vector that contains the temperature (degrees C or degrees
Fahrenheit), if known.}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units or \code{Eng} for English units
(United States Customary System in the United States and Imperial Units in
the United Kingdom)]}

\item{type}{character vector that contains the type of trapezoid (symmetrical
or non-symmetrical). The symmetrical trapezoid uses \code{m} while the non-
symmetrical trapezoid uses \code{m1} and \code{m2}.}

\item{critical}{character vector that contains the type of critical parameters
calculations (\code{approximate} or \code{accurate}). The accurate calculation
provides parameters where the Froude number is 1. The approximate calculation
calculates the values without having the Froude number return 1.}

\item{output}{character vector that contains the output type, either it will be
a \code{\link[base]{list}} or \code{\link[data.table]{data.table}}. The list is
the easiest to obtain a singular value.}
}
\value{
the missing parameters (Q, n, b, m, m1, m2, Sf, or y) & V (velocity),
  Flow depth (y), Bottom width (b), symmetric side slope (m), Slope (Sf),
  A (area), P (wetted perimeters), R (hydraulic radius), B (top width), D
  (hydraulic depth), w (Wetted Length), w1 (Wetted Length for a
  non-symmetric trapezoid), w2 (Wetted Length for a non-symmetric trapezoid),
  Z (Section Factor), E (Specific Energy), K (conveyance), Vel_Head (Velocity
  Head), Re (Reynolds number), Fr (Froude number), taud (maximum shear
  stress), tau0 (average shear stress), yc (critical depth), Ac (critical
  area), Pc (critical wetted perimeters), Bc (critical top width), Rc (critical
  hydraulic radius), Dc (critical hydraulic depth), Vc (critical velocity), Qc
  (critical discharge), Sfc (critical slope), Frc (critical Froude number), Zc
  (critical Section Factor), Ec (critical Specific Energy) as a \code{\link[base]{list}}.
  Alternatively, the Flow depth (y), Flow area (A), Wetted Perimeters (P),
  Top Width (B), Bottom width (b), Hydraulic Radius (R), Hydraulic Depth (D),
  Flow Mean Velocity (V), Flow Discharge (Q), Manning's roughness coefficient
  (n), Slope (Sf), Temperature, Absolute Temperature, Saturated Liquid
  Density, Absolute or Dynamic Viscosity, Kinematic Viscosity, Froude number
  (Fr), Reynolds number (Re), symmetric side slope (m), non-symmetric side
  slope (m1), non-symmetric side slope (m2), Wetted Length (w), Wetted Length
  for a non-symmetric trapezoid (w1), Wetted Length for a non-symmetric
  trapezoid (w2), Section Factor (Z), conveyance (K), Specific Energy (E),
  Velocity Head (Vel_Head), Maximum Shear Stress (taud), Average Shear Stress
  (tau0) along with the associated units can be returned in a \code{\link[data.table]{data.table}}.
  Both the normal and the critical values (where present) are returned in the
  table.
}
\description{
This function solves for one missing variable in the Gauckler-Manning-
Strickler equation for a trapezoidal cross-section and uniform flow. The
\code{\link[stats]{uniroot}} function is used to obtain the missing parameters.
This function provides both normal and critical parameters values.
}
\details{
Critical State Discussion from Chow pages 13, 63
"When F (Froude number) is equal to unity, ... the flow is said to be in a 
\emph{critical} state. If F is less than unity, ... the flow is \emph{subcritical}. If
F is greater than unity, ... the flow is \emph{supercritical}."

"... the critical state of flow through a channel section is characterized
by several important conditions. Recapitulating, they are (1) the specific
energy is a minimum for a given discharge; (2) the discharge is a maximum
for a given specific energy; (3) the specific force is a minimum for a given
discharge; (4) the velocity head is equal to half the hydraulic depth in a
channel of small slope; (5) the Froude number is equal to unity; and (6) the
velocity of flow in a channel of small slope with uniform velocity
distribution is equal to the celerity of small gravity waves in shallow
water caused by local disturbances."

"Discussions on critical state of flow have referred mainly to a particular
section of a channel, known as the \emph{critical section}. If the critical state
of exists throughout the entire length of the channel or over a reach of the
channel, the flow in the channel is a \emph{critical flow}."
}
\examples{

# Example 1

library(iemisc)
# Exercise 4.1 from Sturm (page 153)

uuc <- Manningtrap_critical(Q = 3000, b = 40, m = 3, Sf = 0.002, n = 0.025,
units = "Eng", type = "symmetrical", critical = "accurate", output = "list")
# Q = 3000 cfs, b = 40 ft, m = 3, Sf = 0.002 ft/ft, n = 0.025,
# units = English units
# This will solve for y since it is missing and y will be in ft

uuc$y # only returns y

uuc # returns all results



# Example 2

# Please refer to the iemisc: Manning... Examples using iemiscdata
# [https://www.ecoccs.com/R_Examples/Manning_iemiscdata_Examples.pdf] and iemisc:
# Open Channel Flow Examples involving Geometric Shapes with the
# Gauckler-Manning-Strickler Equation
# [https://www.ecoccs.com/R_Examples/Open-Channel-Flow_Examples_Geometric_Shapes.pdf]
# for the cross-section examples using iemiscdata







}
\references{
Ven Te Chow, Ph.D., \emph{Open-Channel Hydraulics}, McGraw-Hill Classic Textbook Reissue, New York City, New York: McGraw-Hill Book Company, 1988, pages 13, 63.
}
\author{
Irucka Embry
}
