% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construction_fraction.R
\encoding{UTF-8}
\name{construction_fraction}
\alias{construction_fraction}
\title{Construction Fraction}
\usage{
construction_fraction(
  measurement,
  type = c("traditional", "librecad"),
  result = c("traditional", "inch"),
  fraction = c(0, 2, 4, 8, 16, 32, 64, 100, 128, 256)
)
}
\arguments{
\item{measurement}{numeric vector that contains the construction
measurement as a decimal}

\item{type}{character vector that contains the decimal type [options are
traditional (ex. 1.203125 = 1'-2 7/16\"] where the whole number is the
value in ft and the decimal is the value in inches & librecad
(ex. 14.4375 = 1'-2 7/16\"), whereby LibreCAD defines its decimal unit as
"integer part separated from the fractional part of a number by a
decimal". Thus, both the whole number and the decimal is the value in
inches.}

\item{result}{character vector that contains the resulting fraction type
(options are traditional (ex. 1.203125 = 1 ft 2 7/16 in) & inch
(ex. 14.4375 = 14 7/16 in)). This is the same as fractional (fractional
inch) in LibreCAD.}

\item{fraction}{numeric vector that contains the fractional part to return.
The options are 0, 2, 4, 8, 16, 32, 64, 100, 128, or 256.}
}
\value{
the construction measurement value as a character \code{\link[base]{vector}} as
    foot + fraction of an inch or as inch + fraction of an inch (depends on
    the parameters)
}
\description{
Convert a construction measurement in US Customary Units as a decimal into
its nearest equivalent as foot + inch with or without a fraction
}
\examples{

# Please refer to the iemisc: Construction Measurement Examples vignette for
# additional examples

library(iemisc)

# Example 1 from the Spike Reference

check1 <- 18.649 # decimal feet

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 16)

# Reverse the calculation to check out the absolute error

check2 <- construction_decimal(construction_fraction(check1,
type = "traditional", result = "traditional", fraction = 16),
result = "traditional", output = "vector")

fracture::fracture(check2 - check1) # difference in inches

# by approximate error

approxerror(check2, check1) # answer as a percent (\\%)


# check all other fraction levels

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 0)

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 2)

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 4)

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 8)

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 32)

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 64)

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 100)

construction_fraction(check1, type = "traditional", result =
"traditional", fraction = 128)





# Example 2

library(iemisc)
import::from(fpCompare, "\%==\%")


x1 <- construction_fraction(1.203125, type = "traditional", result =
"traditional", fraction = 16)

x2 <- construction_fraction(14.4375, type = "librecad", result =
"inch", fraction = 16)

x3 <- construction_fraction(14.4375, type = "librecad", result =
"traditional", fraction = 16)

x4 <- construction_fraction(14.43112, type = "librecad", result =
"traditional", fraction = 16)

x5 <- construction_fraction(14.43112, type = "librecad", result =
"inch", fraction = 16)


ex1 <- frac_to_numeric(x2)

ex2 <- construction_decimal(x1, result = "librecad", output = "vector")

ex3 <- construction_decimal(x3, result = "librecad", output = "vector")

ex4 <- construction_decimal(x4, result = "librecad", output = "vector")

ex5 <- frac_to_numeric(x5)


# check if ex1, ex2, ex3, ex4, and ex5 are equivalent
ex1 \%==\% ex2

ex1 \%==\% ex3

ex1 \%==\% ex4

ex1 \%==\% ex5

ex2 \%==\% ex3

ex2 \%==\% ex4

ex2 \%==\% ex5

ex3 \%==\% ex4

ex3 \%==\% ex5

ex4 \%==\% ex5




# Example 3 (from the Inch Calculator Reference)

library(iemisc)

construction_fraction(2.695, type = "librecad", result = "traditional",
fraction = 16)

construction_fraction(2.695, type = "librecad", result = "inch",
fraction = 16)




# Example 4

library(iemisc)

construction_fraction(17.71354, type = "traditional", result = "traditional",
fraction = 16)

construction_fraction(17.71354, type = "traditional", result = "inch",
fraction = 16)















}
\references{
\enumerate{
   \item Spike, 7 May 2022, "How to Convert Feet in Decimal Format to Foot, Inch and Fraction Values", \url{https://www.spikevm.com/construction-math/convert-decimal-fraction.php}.
   \item myCarpentry, 7 May 2022, "Online Fraction Calculator", \url{https://www.mycarpentry.com/online-fraction-calculator.html}.
   \item LibreCAD, User Manual - Fundamentals: Units: Architectural and Decimal, 7 May 2022, \url{https://librecad-docs-dev.readthedocs.io/en/latest/ref/fundamentals.html#units}.
   \item Inch Calculator. Inch Fraction Calculator – Convert Decimal to Inches, 9 May 2022, \url{https://www.inchcalculator.com/inch-fraction-calculator/}.
}
}
\author{
Irucka Embry
}
