% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igate.regressions.R
\name{igate.regressions}
\alias{igate.regressions}
\title{Produces the regression plots for sanity check in iGATE}
\usage{
igate.regressions(df, target, ssv = NULL,
  outlier_removal_target = TRUE, outlier_removal_ssv = TRUE,
  savePlots = FALSE, image_directory = tempdir())
}
\arguments{
\item{df}{Data frame to be analysed.}

\item{target}{Target varaible to be analysed.}

\item{ssv}{A vector of suspected sources of variation. These are the variables
in \code{df} which we believe might have an influence on the target variable and
will be tested. If no list of ssv is provided, the test will be performed
on all numeric variables.}

\item{outlier_removal_target}{Logical. Should outliers (with respect to the target variable)
be removed from df (default: \code{TRUE})? Important: This only makes sense if no
prior outlier removal has been performed on df, i.e. \code{df} still contains all
the data. Otherwise calculation for outlier threshold will be falsified.}

\item{outlier_removal_ssv}{Logical. Should outlier removal be performed for each ssv (default: \code{TRUE})?}

\item{savePlots}{Logical. If \code{FALSE} (the default) regression plots will be output to the standard plotting
device. If \code{TRUE}, regression plots will additionally be saved to \code{image_directory} as png files.}

\item{image_directory}{Directory to which plots should be saved. This is only used if \code{savePlots = TRUE} and
defaults to the temporary directory of the current R session, i.e. \code{tempdir()}. To save plots to the current
working directory set \code{savePlots = TRUE} and \code{image_directory = getwd()}.}
}
\value{
The regression plots of \code{target} against each \code{ssv} are written as
.png file into the current working directory. Also, a data frame with the following
columns is output
\tabular{ll}{
\code{Causes} \tab The \code{ssv} that were analysed.\cr
\code{outliers_removed} \tab How many outliers (with respect to this \code{ssv})
have been removed before fitting the linear model?\cr
\code{observations_retained} \tab After outlier removal was performed, how many observations
were left and used to fit the model?\cr
\code{regression_plot} \tab Logical. Was fitting the model successful? It can fail,
for example, if a ssv is constant.\cr
\code{r_squared} \tab r^2 value of model.\cr
\code{gradient, intercept} \tab Gradient and intercept of fitted model.
}
}
\description{
This function takes a data frame, a target variable and a list of ssv and
produces a regression plot of each ssv against the target. The output can written as
.png file into the current working directory. Also, summary statistics are provided.
}
\details{
Regression plots for each \code{ssv} against \code{target} are produced and
svaed to current working directory. Also a data frame with summary statistics is produced,
see \bold{Value} for details.
}
\examples{
igate.regressions(iris, target = "Sepal.Length")

}
