% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasagna_plots.R
\name{plot_lasagna}
\alias{plot_lasagna}
\title{Lasagna plot of glucose values for multiple subjects}
\usage{
plot_lasagna(
  data,
  datatype = c("all", "average"),
  lasagnatype = c("unsorted", "timesorted", "subjectsorted"),
  maxd = 14,
  limits = c(50, 500),
  midpoint = 105,
  LLTR = 80,
  ULTR = 140,
  dt0 = NULL,
  inter_gap = 60,
  tz = ""
)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}

\item{datatype}{String corresponding to data aggregation used for plotting, currently supported options are 'all' which plots all glucose measurements within the first \code{maxd} days for each subject, and 'average' which plots average 24 hour glucose values across days for each subject}

\item{lasagnatype}{String corresponding to plot type when using\code{datatype = "average"}, currently supported options are 'unsorted' for an unsorted lasagna plot, 'timesorted' for a lasagna plot with glucose values sorted within each time point across subjects, and '`subjectsorted`' for a lasagna plot with glucose values sorted within each subject across time points.}

\item{maxd}{For datatype "all", maximal number of days to be plotted from the study. The default value is 14 days (2 weeks).}

\item{limits}{The minimal and maximal glucose values for coloring grid which is gradient from blue (minimal) to red (maximal), see \code{\link{scale_fill_gradient2}})}

\item{midpoint}{The glucose value serving as midpoint (white) of the diverging gradient scale (see \code{\link{scale_fill_gradient2}}). The default value is 125 mg/dL. The values above are colored in red, and below in blue.}

\item{LLTR}{Lower Limit of Target Range, default value is 80 mg/dL.}

\item{ULTR}{Upper Limit of Target Range, default value is 140 mg/dL.}

\item{dt0}{The time frequency for interpolated aligned grid in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation of
NA glucose values. The values will not be interpolated between
the glucose measurements that are more than inter_gap minutes apart.
The default value is 60 min.}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
A ggplot object corresponding to lasagna plot
}
\description{
Lasagna plot of glucose values for multiple subjects
}
\examples{

plot_lasagna(example_data_5_subject, datatype = "average", lasagnatype = 'timesorted', tz = "EST")
plot_lasagna(example_data_5_subject, lasagnatype = "subjectsorted", LLTR = 100, tz = "EST")

}
\references{
Swihart et al. (2010) Lasagna Plots: A Saucy Alternative to Spaghetti Plots, \emph{Epidemiology} \strong{21}(5), 621-625, \doi{10.1097/EDE.0b013e3181e5b06a}
}
