% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{metrics_heatmap}
\alias{metrics_heatmap}
\title{Create a heatmap of metric values by subject based on hierarchical clustering order}
\usage{
metrics_heatmap(
  data = NULL,
  metrics = NULL,
  metric_cluster = 6,
  clustering_method = "complete",
  clustering_distance_metrics = "correlation",
  clustering_distance_subjects = "correlation"
)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}

\item{metrics}{precalculated metric values, with first column corresponding to subject id. If 'NULL', the metrics are calculated from supplied 'data' using \code{\link{all_metrics}}}

\item{metric_cluster}{number of visual metric clusters, default value is 6}

\item{clustering_method}{the agglomeration method for hierarchical clustering, accepts same values as \code{\link{hclust}}, default value is 'complete'}

\item{clustering_distance_metrics}{the distance measure for metrics clustering, accepts same values as \code{\link{dist}}, default value is 'correlation' distance}

\item{clustering_distance_subjects}{the distance measure for subjects clustering, accepts same values as \code{\link{dist}}, default value is 'correlation' distance}
}
\value{
A heatmap of metrics by subjects generated via \code{\link{pheatmap}}
}
\description{
Create a heatmap of metric values by subject based on hierarchical clustering order
}
\examples{
# Using default (all metrics)
metrics_heatmap(example_data_5_subject)
# Using pre-calculated metrics
mecs = all_metrics(example_data_5_subject)
metrics_heatmap(metrics = mecs)

# Using pre-calculated sd metrics only
mecs = sd_measures(example_data_5_subject)
metrics_heatmap(metrics = mecs)
}
