% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/centralization.R
\name{centr_degree_tmax}
\alias{centr_degree_tmax}
\alias{centralization.degree.tmax}
\title{Theoretical maximum for degree centralization}
\usage{
centr_degree_tmax(graph = NULL, nodes = 0, mode = c("all", "out", "in",
  "total"), loops = FALSE)
}
\arguments{
\item{graph}{The input graph. It can also be \code{NULL}, if
\code{nodes}, \code{mode} and \code{loops} are all given.}

\item{nodes}{The number of vertices. This is ignored if the graph is given.}

\item{mode}{This is the same as the \code{mode} argument of
\code{degree}.}

\item{loops}{Logical scalar, whether to consider loops edges when
calculating the degree.}
}
\value{
Real scalar, the theoratical maximum (unnormalized) graph degree
  centrality score for graphs with given order and other parameters.
}
\description{
See \code{\link{centralize}} for a summary of graph centralization.
}
\examples{
# A BA graph is quite centralized
g <- sample_pa(1000, m = 4)
centr_degree(g, normalized = FALSE)$centralization \%>\%
 `/`(centr_degree_tmax(g))
centr_degree(g, normalized = TRUE)$centralization
}
\seealso{
Other centralization related: \code{\link{centr_betw_tmax}},
  \code{\link{centralization.betweenness.tmax}};
  \code{\link{centr_betw}},
  \code{\link{centralization.betweenness}};
  \code{\link{centr_clo_tmax}},
  \code{\link{centralization.closeness.tmax}};
  \code{\link{centr_clo}},
  \code{\link{centralization.closeness}};
  \code{\link{centr_degree}},
  \code{\link{centralization.degree}};
  \code{\link{centr_eigen_tmax}},
  \code{\link{centralization.evcent.tmax}};
  \code{\link{centr_eigen}},
  \code{\link{centralization.evcent}};
  \code{\link{centralization}}, \code{\link{centralize}},
  \code{\link{centralize.scores}}
}

