% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{coreness}
\alias{coreness}
\alias{graph.coreness}
\title{K-core decomposition of graphs}
\usage{
coreness(graph, mode = c("all", "out", "in"))
}
\arguments{
\item{graph}{The input graph, it can be directed or undirected}

\item{mode}{The type of the core in directed graphs. Character constant,
possible values: \verb{in}: in-cores are computed, \code{out}: out-cores are
computed, \code{all}: the corresponding undirected graph is considered. This
argument is ignored for undirected graphs.}
}
\value{
Numeric vector of integer numbers giving the coreness of each
vertex.
}
\description{
The k-core of graph is a maximal subgraph in which each vertex has at least
degree k. The coreness of a vertex is k if it belongs to the k-core but not
to the (k+1)-core.
}
\details{
The k-core of a graph is the maximal subgraph in which every vertex has at
least degree k. The cores of a graph form layers: the (k+1)-core is always a
subgraph of the k-core.

This function calculates the coreness for each vertex.
}
\examples{

g <- make_ring(10)
g <- add_edges(g, c(1, 2, 2, 3, 1, 3))
coreness(g) # small core triangle in a ring

}
\references{
Vladimir Batagelj, Matjaz Zaversnik: An O(m) Algorithm for Cores
Decomposition of Networks, 2002

Seidman S. B. (1983) Network structure and minimum degree, \emph{Social
Networks}, 5, 269--287.
}
\seealso{
\code{\link[=degree]{degree()}}

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{diameter}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_matching}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
