% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_with_mds}
\alias{layout_with_mds}
\alias{layout.mds}
\alias{with_mds}
\title{Graph layout by multidimensional scaling}
\usage{
layout_with_mds(graph, dist = NULL, dim = 2, options = arpack_defaults())

with_mds(...)
}
\arguments{
\item{graph}{The input graph.}

\item{dist}{The distance matrix for the multidimensional scaling.  If
\code{NULL} (the default), then the unweighted shortest path matrix is used.}

\item{dim}{\code{layout_with_mds()} supports dimensions up to the number of nodes
minus one, but only if the graph is connected; for unconnected graphs, the
only possible value is 2. This is because \code{merge_coords()} only works in
2D.}

\item{options}{This is currently ignored, as ARPACK is not used any more for
solving the eigenproblem}

\item{...}{Passed to \code{layout_with_mds()}.}
}
\value{
A numeric matrix with \code{dim} columns.
}
\description{
Multidimensional scaling of some distance matrix defined on the vertices of
a graph.
}
\details{
\code{layout_with_mds()} uses classical multidimensional scaling (Torgerson scaling)
for generating the coordinates. Multidimensional scaling aims to place points
from a higher dimensional space in a (typically) 2 dimensional plane, so that
the distances between the points are kept as much as this is possible.

By default igraph uses the shortest path matrix as the distances between the
nodes, but the user can override this via the \code{dist} argument.

Warning: If the graph is symmetric to the exchange of two vertices (as is the
case with leaves of a tree connecting to the same parent), classical
multidimensional scaling may assign the same coordinates to these vertices.

This function generates the layout separately for each graph component and
then merges them via \code{\link[=merge_coords]{merge_coords()}}.
}
\examples{

g <- sample_gnp(100, 2 / 100)
l <- layout_with_mds(g)
plot(g, layout = l, vertex.label = NA, vertex.size = 3)
}
\references{
Cox, T. F. and Cox, M. A. A. (2001) \emph{Multidimensional
Scaling}.  Second edition. Chapman and Hall.
}
\seealso{
\code{\link[=layout]{layout()}}, \code{\link[=plot.igraph]{plot.igraph()}}

Other graph layouts: 
\code{\link{add_layout_}()},
\code{\link{component_wise}()},
\code{\link{layout_as_bipartite}()},
\code{\link{layout_as_star}()},
\code{\link{layout_as_tree}()},
\code{\link{layout_in_circle}()},
\code{\link{layout_nicely}()},
\code{\link{layout_on_grid}()},
\code{\link{layout_on_sphere}()},
\code{\link{layout_randomly}()},
\code{\link{layout_with_dh}()},
\code{\link{layout_with_fr}()},
\code{\link{layout_with_gem}()},
\code{\link{layout_with_graphopt}()},
\code{\link{layout_with_kk}()},
\code{\link{layout_with_lgl}()},
\code{\link{layout_with_sugiyama}()},
\code{\link{layout_}()},
\code{\link{merge_coords}()},
\code{\link{norm_coords}()},
\code{\link{normalize}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com}
}
\concept{graph layouts}
\keyword{graphs}
