% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewire.R
\name{each_edge}
\alias{each_edge}
\title{Rewires the endpoints of the edges of a graph to a random vertex}
\usage{
each_edge(
  prob,
  loops = FALSE,
  multiple = FALSE,
  mode = c("all", "out", "in", "total")
)
}
\arguments{
\item{prob}{The rewiring probability, a real number between zero and one.}

\item{loops}{Logical scalar, whether loop edges are allowed in the rewired
graph.}

\item{multiple}{Logical scalar, whether multiple edges are allowed in the
generated graph.}

\item{mode}{Character string, specifies which endpoint of the edges to rewire
in directed graphs. \sQuote{all} rewires both endpoints, \sQuote{in} rewires
the start (tail) of each directed edge, \sQuote{out} rewires the end (head)
of each directed edge. Ignored for undirected graphs.}
}
\description{
This function can be used together with \code{\link[=rewire]{rewire()}}.
This method rewires the endpoints of the edges with a constant probability
uniformly randomly to a new vertex in a graph.
}
\details{
Note that this method might create graphs with multiple and/or loop edges.
}
\examples{

# Some random shortcuts shorten the distances on a lattice
g <- make_lattice(length = 100, dim = 1, nei = 5)
mean_distance(g)
g <- rewire(g, each_edge(prob = 0.05))
mean_distance(g)

# Rewiring the start of each directed edge preserves the in-degree distribution
# but not the out-degree distribution
g <- sample_pa(1000)
g2 <- g \%>\% rewire(each_edge(mode = "in", multiple = TRUE, prob = 0.2))
degree(g, mode = "in") == degree(g2, mode = "in")
}
\seealso{
Other rewiring functions: 
\code{\link{keeping_degseq}()},
\code{\link{rewire}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{rewiring functions}
\keyword{graphs}
