% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibfix.R, R/bibstats.R
\name{fix_bib}
\alias{fix_bib}
\alias{bibstats}
\alias{percent_female}
\alias{mean_year}
\alias{mean_pages}
\alias{total_pages}
\title{Reporting bibliographic statistics}
\usage{
fix_bib(bib_file)

percent_female(bib_file, rmd_file, by = c("author", "publication"))

mean_year(bib_file, rmd_file)

mean_pages(bib_file, rmd_file)

total_pages(bib_file, rmd_file)
}
\arguments{
\item{bib_file}{A .bib file for the project.
If not given, the functions will search for a .bib file in the folder
associated with the file the source editor has open.}

\item{rmd_file}{A .rmd file
If not given, the functions will check to see whether the
current file open in the source editor is an .rmd file,
and if so use that.}

\item{by}{A string in c("author", "publication") which determines if the
percentage of female authors is computed across all papers or the percentage
represents the proportion of papers written by at least one woman.}
}
\value{
Prints a summary statistic (e.g. mean or proportion)
}
\description{
These functions are useful for calculating salient statistics
on the bibliographies used for dissertations or syllabi. They include the
following functions/metrics:
}
\details{
\describe{
\item{\code{percent_female()}}{Displays the percentage of authors in a
\code{.bib} file that are female. See the \code{{gender}} package for more details.}
\item{\code{mean_year()}}{Displays the average year of publication of the items
in a given \code{.bib} file.}
\item{\code{mean_pages()}}{Displays the average number of pages of the items
in a given \code{.bib} file.}
\item{\code{total_pages()}}{Displays the total number of pages of all items
in a given \code{.bib} file.}
}
}
