% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cda3.R
\name{cov_cda_r}
\alias{cov_cda_r}
\title{Optimize a linear regression model by coordinate descent algorithm using a covariance matrix with R}
\usage{
cov_cda_r(Gamma, gamma, lambda, R, init.beta, delta, maxit, eps, warm, strong,
  sparse)
}
\arguments{
\item{Gamma}{covariance matrix of explanatory variables}

\item{gamma}{covariance vector of explanatory and objective variables}

\item{lambda}{lambda sequence}

\item{R}{matrix using exclusive penalty term}

\item{init.beta}{initial values of beta}

\item{delta}{ratio of regularization between l1 and exclusive penalty terms}

\item{maxit}{max iteration}

\item{eps}{convergence threshold for optimization}

\item{warm}{warm start direction: "lambda" (default) or "delta"}

\item{strong}{whether use strong screening or not}

\item{sparse}{whether use sparse matrix or not}
}
\value{
standardized beta
}
\description{
Optimize a linear regression model by coordinate descent algorithm using a covariance matrix with R
}
\keyword{internal}
