% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imTools.R
\name{iprior}
\alias{iprior}
\title{Characterizing Imprecise Prior}
\usage{
iprior(ui, ci, pmat)
}
\arguments{
\item{ui}{constraint matrix (k x p), see below.}

\item{ci}{constrain vector of length k, see below.}

\item{pmat}{matrix (k x p) containig coordinate information in d-dimensions.}
}
\description{
A set of prior distributions is characterized as an imprecise prior for inference.  See \sQuote{Details}.
}
\details{
A convex set of hyperparameters is charcterized using a set of linear inequalities.   \code{grDevices::chull} and \code{geometry::convhulln} functions are used to search for extreme points of this convex set.
}
\examples{
## 2-dims (xi2=0, xi1, xi0)
lc0 <- list(lhs=rbind(diag(2), -diag(2)), rhs=c(0,0,-1,-1))
op <- iprior(ui=rbind(diag(2), -diag(2)), ci=c(0,0,-1,-1)) 
op <- iprior(ui=rbind(c(1,0),c(0,1),c(-1,-1)), ci=c(0,0,-5)) 
op <- iprior(ui=rbind(c(1,0),c(0,1),c(0,-1),c(1,1),c(-2,-1)), 
             ci=c(1,2,-8,5,-14)) # (3,8),(1,8), (1,4),(3,2)(6,2)

## 3-dimes (xi2, xi1, xi0)
op <- iprior(ui=rbind(c(1,0,0), c(-1,0,0), c(0,1,0), c(0,-1,0), c(0,0,1)), 
             ci=c(-0.5, -1, -2, -2, 0))
op <- iprior(ui=rbind(c(1,0), c(-1,0), c(0,1), c(0,-1)), 
             ci=c(0.5, -1, -2, -2))
lc0 <- cbind(rbind(c(1,0,0), c(-1,0,0), c(0,1,0), c(0,-1,0), c(0,0,1), 
             c(0,0,-1)), c(0.5, -1, -2, -2,0,-1))
iprior(pmat=lc0)
lc0 <- rbind(c(-2,1,0), c(2,1,0), c(-2,0.5,0), c(2,0.5,0))
lc0 <- rbind(c(1,2,0), c(1,-2,0), c(0.5,-2,0), c(0.5,2,0)) 
iprior(pmat=lc0)

}

